/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.DiscardableAction;
import rx.concurrency.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;

public class NewThreadScheduler
extends Scheduler {
    private static final NewThreadScheduler INSTANCE = new NewThreadScheduler();
    private static final AtomicLong count = new AtomicLong();

    public static NewThreadScheduler getInstance() {
        return INSTANCE;
    }

    private NewThreadScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        EventLoopScheduler s = new EventLoopScheduler();
        return s.schedule(state, action);
    }

    @Override
    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delay, TimeUnit unit) {
        final NewThreadScheduler _scheduler = this;
        final CompositeSubscription subscription = new CompositeSubscription(new Subscription[0]);
        ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                if (!subscription.isUnsubscribed()) {
                    Subscription s = _scheduler.schedule(state, action);
                    subscription.add(s);
                }
            }
        }, delay, unit);
        subscription.add(Subscriptions.from(f));
        return subscription;
    }

    private static class EventLoopScheduler
    extends Scheduler {
        private final ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "RxNewThreadScheduler-" + count.incrementAndGet());
            }
        });

        private EventLoopScheduler() {
        }

        @Override
        public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
            final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
            final CompositeSubscription subscription = new CompositeSubscription(discardableAction);
            final EventLoopScheduler _scheduler = this;
            subscription.add(Subscriptions.from(this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Subscription s = discardableAction.call(_scheduler);
                    subscription.add(s);
                }
            })));
            return subscription;
        }

        @Override
        public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
            final EventLoopScheduler _scheduler = this;
            final CompositeSubscription subscription = new CompositeSubscription(new Subscription[0]);
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!subscription.isUnsubscribed()) {
                        Subscription s = _scheduler.schedule(state, action);
                        subscription.add(s);
                    }
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
            return subscription;
        }
    }
}

