/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class OperationToObservableIterable<T> {
    public static <T> Observable.OnSubscribeFunc<T> toObservableIterable(Iterable<? extends T> list) {
        return new ToObservableIterable<T>(list);
    }

    private static class ToObservableIterable<T>
    implements Observable.OnSubscribeFunc<T> {
        public Iterable<? extends T> iterable;

        public ToObservableIterable(Iterable<? extends T> list) {
            this.iterable = list;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            for (T item : this.iterable) {
                observer.onNext(item);
            }
            observer.onCompleted();
            return Subscriptions.empty();
        }
    }
}

