/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observer;
import rx.operators.SafeObservableSubscription;
import rx.plugins.RxJavaPlugins;
import rx.util.CompositeException;
import rx.util.OnErrorNotImplementedException;

public class SafeObserver<T>
implements Observer<T> {
    private final Observer<? super T> actual;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final SafeObservableSubscription subscription;

    public SafeObserver(SafeObservableSubscription subscription, Observer<? super T> actual) {
        this.subscription = subscription;
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (this.isFinished.compareAndSet(false, true)) {
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e) {
                this.onError(e);
            }
            this.subscription.unsubscribe();
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.isFinished.compareAndSet(false, true)) {
            try {
                this.actual.onError(e);
            }
            catch (Throwable e2) {
                if (e2 instanceof OnErrorNotImplementedException) {
                    throw (OnErrorNotImplementedException)e2;
                }
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e2);
                throw new RuntimeException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e, e2)));
            }
            this.subscription.unsubscribe();
        }
    }

    @Override
    public void onNext(T args) {
        try {
            if (!this.isFinished.get()) {
                this.actual.onNext(args);
            }
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }
}

