/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public final class OperationTakeLast {
    public static <T> Observable.OnSubscribeFunc<T> takeLast(final Observable<? extends T> items, final int count) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new TakeLast(items, count).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        @Test
        public void testTakeLastEmpty() {
            Observable w = Observable.empty();
            Observable take = Observable.create(OperationTakeLast.takeLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Matchers.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLast1() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            take.subscribe(aObserver);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLast2() {
            Observable<String> w = Observable.from("one");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 10));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLastWithZeroCount() {
            Observable<String> w = Observable.from("one");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 0));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLastWithNull() {
            Observable<String> w = Observable.from("one", null, "three");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(null);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLastWithNegativeCount() {
            Observable<String> w = Observable.from("one");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, -1));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any(IndexOutOfBoundsException.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }
    }

    private static class TakeLast<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int count;
        private final Observable<? extends T> items;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        TakeLast(Observable<? extends T> items, int count) {
            this.count = count;
            this.items = items;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.count < 0) {
                throw new IndexOutOfBoundsException("count could not be negative");
            }
            return this.subscription.wrap(this.items.subscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        implements Observer<T> {
            private Deque<T> deque = new LinkedList();
            private final Observer<? super T> observer;
            private final ReentrantLock lock = new ReentrantLock();

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                try {
                    for (Object value : this.deque) {
                        this.observer.onNext(value);
                    }
                    this.observer.onCompleted();
                }
                catch (Throwable e) {
                    this.observer.onError(e);
                }
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T value) {
                if (TakeLast.this.count == 0) {
                    return;
                }
                this.lock.lock();
                try {
                    this.deque.offerLast(value);
                    if (this.deque.size() > TakeLast.this.count) {
                        this.deque.removeFirst();
                    }
                }
                catch (Throwable e) {
                    this.observer.onError(e);
                    TakeLast.this.subscription.unsubscribe();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

