/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.BooleanSubscription;

public final class OperationConcat {
    public static <T> Observable.OnSubscribeFunc<T> concat(Observable<? extends T> ... sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(Iterable<? extends Observable<? extends T>> sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(Observable<? extends Observable<? extends T>> sequences) {
        return new Concat(sequences);
    }

    public static class UnitTest {
        @Test
        public void testConcat() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            String[] o = new String[]{"1", "3", "5", "7"};
            String[] e = new String[]{"2", "4", "6"};
            Observable<String[]> odds = Observable.from(o);
            Observable<String[]> even = Observable.from(e);
            Observable concat = Observable.create(OperationConcat.concat(odds, even));
            concat.subscribe(observer);
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)7))).onNext(Mockito.anyString());
        }

        @Test
        public void testConcatWithList() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            String[] o = new String[]{"1", "3", "5", "7"};
            String[] e = new String[]{"2", "4", "6"};
            Observable<String[]> odds = Observable.from(o);
            Observable<String[]> even = Observable.from(e);
            ArrayList<Observable<String[]>> list = new ArrayList<Observable<String[]>>();
            list.add(odds);
            list.add(even);
            Observable concat = Observable.create(OperationConcat.concat(list));
            concat.subscribe(observer);
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)7))).onNext(Mockito.anyString());
        }

        @Test
        public void testConcatObservableOfObservables() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            String[] o = new String[]{"1", "3", "5", "7"};
            String[] e = new String[]{"2", "4", "6"};
            final Observable<String[]> odds = Observable.from(o);
            final Observable<String[]> even = Observable.from(e);
            Observable<Observable<String>> observableOfObservables = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    observer.onNext(odds);
                    observer.onNext(even);
                    observer.onCompleted();
                    return new Subscription(){

                        @Override
                        public void unsubscribe() {
                        }
                    };
                }
            });
            Observable<String> concat = Observable.create(OperationConcat.concat(observableOfObservables));
            concat.subscribe(observer);
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)7))).onNext(Mockito.anyString());
        }

        @Test
        public void testSimpleAsyncConcat() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            TestObservable<String> o1 = new TestObservable<String>("one", "two", "three");
            TestObservable<String> o2 = new TestObservable<String>("four", "five", "six");
            Observable.concat(Observable.create(o1), Observable.create(o2)).subscribe(observer);
            try {
                ((TestObservable)o1).t.join();
                ((TestObservable)o2).t.join();
            }
            catch (Throwable e) {
                throw new RuntimeException("failed waiting on threads");
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{observer});
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("four");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("five");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("six");
        }

        @Test
        public void testNestedAsyncConcat() throws Throwable {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            final TestObservable<String> o1 = new TestObservable<String>("one", "two", "three");
            final TestObservable<String> o2 = new TestObservable<String>("four", "five", "six");
            final TestObservable<String> o3 = new TestObservable<String>("seven", "eight", "nine");
            final CountDownLatch allowThird = new CountDownLatch(1);
            final AtomicReference parent = new AtomicReference();
            Observable<Observable<String>> observableOfObservables = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(final Observer<? super Observable<String>> observer) {
                    final BooleanSubscription s = new BooleanSubscription();
                    parent.set(new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (!s.isUnsubscribed()) {
                                    System.out.println("Emit o1");
                                    observer.onNext(Observable.create(o1));
                                }
                                if (!s.isUnsubscribed()) {
                                    System.out.println("Emit o2");
                                    observer.onNext(Observable.create(o2));
                                }
                                try {
                                    allowThird.await();
                                }
                                catch (InterruptedException e) {
                                    observer.onError(e);
                                }
                                if (!s.isUnsubscribed()) {
                                    System.out.println("Emit o3");
                                    observer.onNext(Observable.create(o3));
                                }
                            }
                            catch (Throwable e) {
                                observer.onError(e);
                            }
                            finally {
                                System.out.println("Done parent Observable");
                                observer.onCompleted();
                            }
                        }
                    }));
                    ((Thread)parent.get()).start();
                    return s;
                }
            });
            Observable.create(OperationConcat.concat(observableOfObservables)).subscribe(observer);
            while (parent.get() == null) {
                Thread.sleep(1L);
            }
            try {
                while (((TestObservable)o1).t == null) {
                    Thread.sleep(1L);
                }
                System.out.println("Thread1 started ... waiting for it to complete ...");
                ((TestObservable)o1).t.join();
                while (((TestObservable)o2).t == null) {
                    Thread.sleep(1L);
                }
                System.out.println("Thread2 started ... waiting for it to complete ...");
                ((TestObservable)o2).t.join();
            }
            catch (Throwable e) {
                throw new RuntimeException("failed waiting on threads", e);
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{observer});
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("four");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("five");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("six");
            ((Observer)inOrder.verify((Object)observer, Mockito.never())).onNext("seven");
            ((Observer)inOrder.verify((Object)observer, Mockito.never())).onNext("eight");
            ((Observer)inOrder.verify((Object)observer, Mockito.never())).onNext("nine");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            allowThird.countDown();
            try {
                while (((TestObservable)o3).t == null) {
                    Thread.sleep(1L);
                }
                ((TestObservable)o3).t.join();
            }
            catch (Throwable e) {
                throw new RuntimeException("failed waiting on threads", e);
            }
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("seven");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("eight");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onNext("nine");
            ((Observer)inOrder.verify((Object)observer, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testBlockedObservableOfObservables() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            String[] o = new String[]{"1", "3", "5", "7"};
            String[] e = new String[]{"2", "4", "6"};
            Observable<String[]> odds = Observable.from(o);
            Observable<String[]> even = Observable.from(e);
            CountDownLatch callOnce = new CountDownLatch(1);
            CountDownLatch okToContinue = new CountDownLatch(1);
            TestObservable<Observable> observableOfObservables = new TestObservable<Observable>(callOnce, okToContinue, (T[])new Observable[]{odds, even});
            Observable.OnSubscribeFunc concatF = OperationConcat.concat(Observable.create(observableOfObservables));
            Observable concat = Observable.create(concatF);
            concat.subscribe(observer);
            try {
                callOnce.await();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                Assert.fail((String)ex.getMessage());
            }
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("1");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("3");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("5");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("7");
            try {
                okToContinue.countDown();
                ((TestObservable)observableOfObservables).t.join();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                Assert.fail((String)ex.getMessage());
            }
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("2");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("4");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("6");
        }

        @Test
        public void testConcatConcurrentWithInfinity() {
            TestObservable<String> w1 = new TestObservable<String>("one", "two", "three");
            TestObservable<String> w2 = new TestObservable<String>("hello", Integer.MAX_VALUE);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            TestObservable<Observable> observableOfObservables = new TestObservable<Observable>(Observable.create(w1), Observable.create(w2));
            Observable.OnSubscribeFunc concatF = OperationConcat.concat(Observable.create(observableOfObservables));
            Observable concat = Observable.create(concatF);
            concat.take(50).subscribe(aObserver);
            try {
                Thread.sleep(25L);
                ((TestObservable)w1).t.join();
                ((TestObservable)w2).t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)47))).onNext("hello");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testConcatNonBlockingObservables() {
            CountDownLatch okToContinueW1 = new CountDownLatch(1);
            CountDownLatch okToContinueW2 = new CountDownLatch(1);
            final TestObservable<String> w1 = new TestObservable<String>(null, okToContinueW1, "one", "two", "three");
            final TestObservable<String> w2 = new TestObservable<String>(null, okToContinueW2, "four", "five", "six");
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<Observable<String>> observableOfObservables = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    observer.onNext(Observable.create(w1));
                    observer.onNext(Observable.create(w2));
                    observer.onCompleted();
                    return new Subscription(){

                        @Override
                        public void unsubscribe() {
                        }
                    };
                }
            });
            Observable<String> concat = Observable.create(OperationConcat.concat(observableOfObservables));
            concat.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onCompleted();
            try {
                okToContinueW1.countDown();
                okToContinueW2.countDown();
                ((TestObservable)w1).t.join();
                ((TestObservable)w2).t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("four");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("five");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("six");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testConcatUnsubscribe() {
            CountDownLatch callOnce = new CountDownLatch(1);
            CountDownLatch okToContinue = new CountDownLatch(1);
            TestObservable<String> w1 = new TestObservable<String>("one", "two", "three");
            TestObservable<String> w2 = new TestObservable<String>(callOnce, okToContinue, (T[])new String[]{"four", "five", "six"});
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable concat = Observable.create(OperationConcat.concat(Observable.create(w1), Observable.create(w2)));
            SafeObservableSubscription s1 = new SafeObservableSubscription();
            try {
                s1.wrap(concat.subscribe(aObserver));
                callOnce.await();
                s1.unsubscribe();
                okToContinue.countDown();
                ((TestObservable)w1).t.join();
                ((TestObservable)w2).t.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("four");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("five");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("six");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onCompleted();
        }

        @Test
        public void testConcatUnsubscribeConcurrent() {
            CountDownLatch callOnce = new CountDownLatch(1);
            CountDownLatch okToContinue = new CountDownLatch(1);
            TestObservable<String> w1 = new TestObservable<String>("one", "two", "three");
            TestObservable<String> w2 = new TestObservable<String>(callOnce, okToContinue, (T[])new String[]{"four", "five", "six"});
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            TestObservable<Observable> observableOfObservables = new TestObservable<Observable>(Observable.create(w1), Observable.create(w2));
            Observable.OnSubscribeFunc concatF = OperationConcat.concat(Observable.create(observableOfObservables));
            Observable concat = Observable.create(concatF);
            Subscription s1 = concat.subscribe(aObserver);
            try {
                callOnce.await();
                s1.unsubscribe();
                okToContinue.countDown();
                ((TestObservable)w1).t.join();
                ((TestObservable)w2).t.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("four");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("five");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("six");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        private static class TestObservable<T>
        implements Observable.OnSubscribeFunc<T> {
            private final Subscription s = new Subscription(){

                @Override
                public void unsubscribe() {
                    TestObservable.this.subscribed = false;
                }
            };
            private final List<T> values;
            private Thread t = null;
            private int count = 0;
            private boolean subscribed = true;
            private final CountDownLatch once;
            private final CountDownLatch okToContinue;
            private final T seed;
            private final int size;

            public TestObservable(T ... values) {
                this(null, null, values);
            }

            public TestObservable(CountDownLatch once, CountDownLatch okToContinue, T ... values) {
                this.values = Arrays.asList(values);
                this.size = this.values.size();
                this.once = once;
                this.okToContinue = okToContinue;
                this.seed = null;
            }

            public TestObservable(T seed, int size) {
                this.values = null;
                this.once = null;
                this.okToContinue = null;
                this.seed = seed;
                this.size = size;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super T> observer) {
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (TestObservable.this.count < TestObservable.this.size && TestObservable.this.subscribed) {
                                if (null != TestObservable.this.values) {
                                    observer.onNext(TestObservable.this.values.get(TestObservable.this.count));
                                } else {
                                    observer.onNext(TestObservable.this.seed);
                                }
                                TestObservable.this.count++;
                                if (null != TestObservable.this.once) {
                                    TestObservable.this.once.countDown();
                                }
                                if (null == TestObservable.this.okToContinue) continue;
                                TestObservable.this.okToContinue.await(5L, TimeUnit.SECONDS);
                            }
                            if (TestObservable.this.subscribed) {
                                observer.onCompleted();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            Assert.fail((String)e.getMessage());
                        }
                    }
                });
                this.t.start();
                return this.s;
            }
        }
    }

    private static class Concat<T>
    implements Observable.OnSubscribeFunc<T> {
        private Observable<? extends Observable<? extends T>> sequences;
        private SafeObservableSubscription innerSubscription = null;

        public Concat(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicBoolean completedOrErred = new AtomicBoolean(false);
            final AtomicBoolean allSequencesReceived = new AtomicBoolean(false);
            final ConcurrentLinkedQueue nextSequences = new ConcurrentLinkedQueue();
            final SafeObservableSubscription outerSubscription = new SafeObservableSubscription();
            final Observer reusableObserver = new Observer<T>(){

                @Override
                public void onNext(T item) {
                    observer.onNext(item);
                }

                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        outerSubscription.unsubscribe();
                        observer.onError(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (nextSequences.isEmpty()) {
                            Concat.this.innerSubscription = null;
                            if (allSequencesReceived.get() && completedOrErred.compareAndSet(false, true)) {
                                observer.onCompleted();
                            }
                        } else {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(((Observable)nextSequences.poll()).subscribe(this));
                        }
                    }
                }
            };
            outerSubscription.wrap(this.sequences.subscribe(new Observer<Observable<? extends T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(Observable<? extends T> nextSequence) {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (Concat.this.innerSubscription == null) {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(nextSequence.subscribe(reusableObserver));
                        } else {
                            nextSequences.add(nextSequence);
                        }
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        if (Concat.this.innerSubscription != null) {
                            Concat.this.innerSubscription.unsubscribe();
                        }
                        observer.onError(e);
                    }
                }

                @Override
                public void onCompleted() {
                    allSequencesReceived.set(true);
                    if (Concat.this.innerSubscription == null && completedOrErred.compareAndSet(false, true)) {
                        observer.onCompleted();
                    }
                }
            }));
            return new Subscription(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unsubscribe() {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (Concat.this.innerSubscription != null) {
                            Concat.this.innerSubscription.unsubscribe();
                        }
                        outerSubscription.unsubscribe();
                    }
                }
            };
        }
    }
}

