/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;

public final class OperationFilter<T> {
    public static <T> Observable.OnSubscribeFunc<T> filter(Observable<? extends T> that, Func1<? super T, Boolean> predicate) {
        return new Filter<T>(that, predicate);
    }

    public static class UnitTest {
        @Test
        public void testFilter() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> observable = Observable.create(OperationFilter.filter(w, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String t1) {
                    return t1.equals("two");
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class Filter<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> that;
        private final Func1<? super T, Boolean> predicate;

        public Filter(Observable<? extends T> that, Func1<? super T, Boolean> predicate) {
            this.that = that;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.that.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    try {
                        if (((Boolean)Filter.this.predicate.call(value)).booleanValue()) {
                            observer.onNext(value);
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            }));
        }
    }
}

