/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.observables.ConnectableObservable;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationInterval {
    public static Observable.OnSubscribeFunc<Long> interval(long interval, TimeUnit unit) {
        return OperationInterval.interval(interval, unit, Schedulers.threadPoolForComputation());
    }

    public static Observable.OnSubscribeFunc<Long> interval(final long interval, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Long>(){

            @Override
            public Subscription onSubscribe(Observer<? super Long> observer) {
                return new Interval(interval, unit, scheduler).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        private TestScheduler scheduler;
        private Observer<Long> observer;
        private Observer<Long> observer2;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
            this.observer = (Observer)Mockito.mock(Observer.class);
            this.observer2 = (Observer)Mockito.mock(Observer.class);
        }

        @Test
        public void testInterval() {
            Observable<Long> w = Observable.create(OperationInterval.interval(1L, TimeUnit.SECONDS, this.scheduler));
            Subscription sub = w.subscribe(this.observer);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(0L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(2L, TimeUnit.SECONDS);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            sub.unsubscribe();
            this.scheduler.advanceTimeTo(4L, TimeUnit.SECONDS);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testWithMultipleSubscribersStartingAtSameTime() {
            Observable<Long> w = Observable.create(OperationInterval.interval(1L, TimeUnit.SECONDS, this.scheduler));
            Subscription sub1 = w.subscribe(this.observer);
            Subscription sub2 = w.subscribe(this.observer2);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            this.scheduler.advanceTimeTo(2L, TimeUnit.SECONDS);
            InOrder inOrder1 = Mockito.inOrder((Object[])new Object[]{this.observer});
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.observer2});
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(1L);
            ((Observer)inOrder2.verify(this.observer2, Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            sub1.unsubscribe();
            sub2.unsubscribe();
            this.scheduler.advanceTimeTo(4L, TimeUnit.SECONDS);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testWithMultipleStaggeredSubscribers() {
            Observable<Long> w = Observable.create(OperationInterval.interval(1L, TimeUnit.SECONDS, this.scheduler));
            Subscription sub1 = w.subscribe(this.observer);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            this.scheduler.advanceTimeTo(2L, TimeUnit.SECONDS);
            Subscription sub2 = w.subscribe(this.observer2);
            InOrder inOrder1 = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            this.scheduler.advanceTimeTo(4L, TimeUnit.SECONDS);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(2L);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(3L);
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.observer2});
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(1L);
            sub1.unsubscribe();
            sub2.unsubscribe();
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder2.verify(this.observer2, Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testWithMultipleStaggeredSubscribersAndPublish() {
            ConnectableObservable<Long> w = Observable.create(OperationInterval.interval(1L, TimeUnit.SECONDS, this.scheduler)).publish();
            Subscription sub1 = w.subscribe(this.observer);
            w.connect();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            this.scheduler.advanceTimeTo(2L, TimeUnit.SECONDS);
            Subscription sub2 = w.subscribe(this.observer2);
            InOrder inOrder1 = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(0L);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            this.scheduler.advanceTimeTo(4L, TimeUnit.SECONDS);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(2L);
            ((Observer)inOrder1.verify(this.observer, Mockito.times((int)1))).onNext(3L);
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.observer2});
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(2L);
            ((Observer)inOrder2.verify(this.observer2, Mockito.times((int)1))).onNext(3L);
            sub1.unsubscribe();
            sub2.unsubscribe();
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)inOrder1.verify(this.observer, Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder2.verify(this.observer2, Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)inOrder2.verify(this.observer2, Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }
    }

    private static class Interval
    implements Observable.OnSubscribeFunc<Long> {
        private final long period;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private long currentValue;

        private Interval(long period, TimeUnit unit, Scheduler scheduler) {
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Long> observer) {
            final Subscription wrapped = this.scheduler.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    observer.onNext(Interval.this.currentValue);
                    Interval.this.currentValue++;
                }
            }, this.period, this.period, this.unit);
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    wrapped.unsubscribe();
                    observer.onCompleted();
                }
            });
        }
    }
}

