/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.OperationMerge;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationMap {
    public static <T, R> Observable.OnSubscribeFunc<R> map(final Observable<? extends T> sequence, final Func1<? super T, ? extends R> func) {
        return new Observable.OnSubscribeFunc<R>(){

            @Override
            public Subscription onSubscribe(Observer<? super R> observer) {
                return new MapObservable(sequence, new Func2<T, Integer, R>(){

                    @Override
                    public R call(T value, Integer unused) {
                        return func.call(value);
                    }
                }).onSubscribe(observer);
            }
        };
    }

    public static <T, R> Observable.OnSubscribeFunc<R> mapWithIndex(final Observable<? extends T> sequence, final Func2<? super T, Integer, ? extends R> func) {
        return new Observable.OnSubscribeFunc<R>(){

            @Override
            public Subscription onSubscribe(Observer<? super R> observer) {
                return new MapObservable(sequence, func).onSubscribe(observer);
            }
        };
    }

    public static <T, R> Observable.OnSubscribeFunc<R> mapMany(Observable<? extends T> sequence, Func1<? super T, ? extends Observable<? extends R>> func) {
        return OperationMerge.merge(Observable.create(OperationMap.map(sequence, func)));
    }

    public static class UnitTest {
        @Mock
        Observer<String> stringObserver;
        @Mock
        Observer<String> stringObserver2;
        static final Func2<String, Integer, String> APPEND_INDEX = new Func2<String, Integer, String>(){

            @Override
            public String call(String value, Integer index) {
                return value + index;
            }
        };

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testMap() {
            Map<String, String> m1 = UnitTest.getMap("One");
            Map<String, String> m2 = UnitTest.getMap("Two");
            Observable<Map<String, String>> observable = Observable.from(m1, m2);
            Observable<String> m = Observable.create(OperationMap.map(observable, new Func1<Map<String, String>, String>(){

                @Override
                public String call(Map<String, String> map) {
                    return map.get("firstName");
                }
            }));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("OneFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("TwoFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testMapWithIndex() {
            Observable<String> w = Observable.from("a", "b", "c");
            Observable<String> m = Observable.create(OperationMap.mapWithIndex(w, APPEND_INDEX));
            m.subscribe(this.stringObserver);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stringObserver});
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("a0");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("b1");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("c2");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testMapWithIndexAndMultipleSubscribers() {
            Observable<String> w = Observable.from("a", "b", "c");
            Observable<String> m = Observable.create(OperationMap.mapWithIndex(w, APPEND_INDEX));
            m.subscribe(this.stringObserver);
            m.subscribe(this.stringObserver2);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stringObserver});
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("a0");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("b1");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onNext("c2");
            ((Observer)inOrder.verify(this.stringObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.stringObserver2});
            ((Observer)inOrder2.verify(this.stringObserver2, Mockito.times((int)1))).onNext("a0");
            ((Observer)inOrder2.verify(this.stringObserver2, Mockito.times((int)1))).onNext("b1");
            ((Observer)inOrder2.verify(this.stringObserver2, Mockito.times((int)1))).onNext("c2");
            ((Observer)inOrder2.verify(this.stringObserver2, Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testMapMany() {
            Observable<Integer> ids = Observable.from(1, 2);
            Observable<String> m = Observable.create(OperationMap.mapMany(ids, new Func1<Integer, Observable<String>>(){

                @Override
                public Observable<String> call(Integer id) {
                    Observable<Map> subObservable = null;
                    if (id == 1) {
                        Map m1 = UnitTest.getMap("One");
                        Map m2 = UnitTest.getMap("Two");
                        subObservable = Observable.from(m1, m2);
                    } else {
                        Map m3 = UnitTest.getMap("Three");
                        Map m4 = UnitTest.getMap("Four");
                        subObservable = Observable.from(m3, m4);
                    }
                    return Observable.create(OperationMap.map(subObservable, new Func1<Map<String, String>, String>(){

                        @Override
                        public String call(Map<String, String> map) {
                            return map.get("firstName");
                        }
                    }));
                }
            }));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("OneFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("TwoFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("ThreeFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("FourFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testMapMany2() {
            Map<String, String> m1 = UnitTest.getMap("One");
            Map<String, String> m2 = UnitTest.getMap("Two");
            Observable<Map<String, String>> observable1 = Observable.from(m1, m2);
            Map<String, String> m3 = UnitTest.getMap("Three");
            Map<String, String> m4 = UnitTest.getMap("Four");
            Observable<Map<String, String>> observable2 = Observable.from(m3, m4);
            Observable<Observable<Map<String, String>>> observable = Observable.from(observable1, observable2);
            Observable<String> m = Observable.create(OperationMap.mapMany(observable, new Func1<Observable<Map<String, String>>, Observable<String>>(){

                @Override
                public Observable<String> call(Observable<Map<String, String>> o) {
                    return Observable.create(OperationMap.map(o, new Func1<Map<String, String>, String>(){

                        @Override
                        public String call(Map<String, String> map) {
                            return map.get("firstName");
                        }
                    }));
                }
            }));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("OneFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("TwoFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("ThreeFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("FourFirst");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testMapWithError() {
            Observable<String> w = Observable.from("one", "fail", "two", "three", "fail");
            Observable<String> m = Observable.create(OperationMap.map(w, new Func1<String, String>(){

                @Override
                public String call(String s) {
                    if ("fail".equals(s)) {
                        throw new RuntimeException("Forced Failure");
                    }
                    return s;
                }
            }));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testMapWithSynchronousObservableContainingError() {
            Observable<String> w = Observable.from("one", "fail", "two", "three", "fail");
            final AtomicInteger c1 = new AtomicInteger();
            final AtomicInteger c2 = new AtomicInteger();
            Observable<String> m = Observable.create(OperationMap.map(w, new Func1<String, String>(){

                @Override
                public String call(String s) {
                    if ("fail".equals(s)) {
                        throw new RuntimeException("Forced Failure");
                    }
                    System.out.println("BadMapper:" + s);
                    c1.incrementAndGet();
                    return s;
                }
            })).map(new Func1<String, String>(){

                @Override
                public String call(String s) {
                    System.out.println("SecondMapper:" + s);
                    c2.incrementAndGet();
                    return s;
                }
            });
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            Assert.assertEquals((long)1L, (long)c1.get());
            Assert.assertEquals((long)1L, (long)c2.get());
        }

        private static Map<String, String> getMap(String prefix) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("firstName", prefix + "First");
            m.put("lastName", prefix + "Last");
            return m;
        }
    }

    private static class MapObservable<T, R>
    implements Observable.OnSubscribeFunc<R> {
        private final Observable<? extends T> sequence;
        private final Func2<? super T, Integer, ? extends R> func;
        private int index;

        public MapObservable(Observable<? extends T> sequence, Func2<? super T, Integer, ? extends R> func) {
            this.sequence = sequence;
            this.func = func;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super R> observer) {
            return this.sequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(MapObservable.this.func.call(value, MapObservable.this.index));
                    MapObservable.this.index++;
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            });
        }
    }
}

