/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.CompositeException;
import rx.util.functions.Func1;

public final class OperationOnErrorResumeNextViaFunction<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorResumeNextViaFunction(Observable<? extends T> originalSequence, Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return new OnErrorResumeNextViaFunction<T>(originalSequence, resumeFunction);
    }

    public static class UnitTest {
        @Test
        public void testResumeNextWithSynchronousExecution() {
            final AtomicReference receivedException = new AtomicReference();
            Observable<String> w = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onError(new Throwable("injected failure"));
                    return Subscriptions.empty();
                }
            });
            Func1<Throwable, Observable<String>> resume = new Func1<Throwable, Observable<String>>(){

                @Override
                public Observable<String> call(Throwable t1) {
                    receivedException.set(t1);
                    return Observable.from("twoResume", "threeResume");
                }
            };
            Observable<String> observable = Observable.create(OperationOnErrorResumeNextViaFunction.onErrorResumeNextViaFunction(w, resume));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("twoResume");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeResume");
            Assert.assertNotNull(receivedException.get());
        }

        @Test
        public void testResumeNextWithAsyncExecution() {
            final AtomicReference receivedException = new AtomicReference();
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable w = new TestObservable(s, "one");
            Func1<Throwable, Observable<String>> resume = new Func1<Throwable, Observable<String>>(){

                @Override
                public Observable<String> call(Throwable t1) {
                    receivedException.set(t1);
                    return Observable.from("twoResume", "threeResume");
                }
            };
            Observable<String> observable = Observable.create(OperationOnErrorResumeNextViaFunction.onErrorResumeNextViaFunction(Observable.create(w), resume));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                w.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("twoResume");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeResume");
            Assert.assertNotNull(receivedException.get());
        }

        @Test
        public void testFunctionThrowsError() {
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable w = new TestObservable(s, "one");
            Func1<Throwable, Observable<String>> resume = new Func1<Throwable, Observable<String>>(){

                @Override
                public Observable<String> call(Throwable t1) {
                    throw new RuntimeException("exception from function");
                }
            };
            Observable<String> observable = Observable.create(OperationOnErrorResumeNextViaFunction.onErrorResumeNextViaFunction(Observable.create(w), resume));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                w.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onCompleted();
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            final Subscription s;
            final String[] values;
            Thread t = null;

            public TestObservable(Subscription s, String ... values) {
                this.s = s;
                this.values = values;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                System.out.println("TestObservable subscribed to ...");
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println("running TestObservable thread");
                            for (String s : TestObservable.this.values) {
                                System.out.println("TestObservable onNext: " + s);
                                observer.onNext(s);
                            }
                            throw new RuntimeException("Forced Failure");
                        }
                        catch (Throwable e) {
                            observer.onError(e);
                            return;
                        }
                    }
                });
                System.out.println("starting TestObservable thread");
                this.t.start();
                System.out.println("done starting TestObservable thread");
                return this.s;
            }
        }
    }

    private static class OnErrorResumeNextViaFunction<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Func1<Throwable, ? extends Observable<? extends T>> resumeFunction;
        private final Observable<? extends T> originalSequence;

        public OnErrorResumeNextViaFunction(Observable<? extends T> originalSequence, Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
            this.resumeFunction = resumeFunction;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(new SafeObservableSubscription());
            subscriptionRef.get().wrap(new SafeObservableSubscription(this.originalSequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(value);
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription != null) {
                        try {
                            Observable resumeSequence = (Observable)OnErrorResumeNextViaFunction.this.resumeFunction.call(ex);
                            SafeObservableSubscription innerSubscription = new SafeObservableSubscription(resumeSequence.subscribe(observer));
                            if (!subscriptionRef.compareAndSet(currentSubscription, innerSubscription)) {
                                innerSubscription.unsubscribe();
                            }
                        }
                        catch (Throwable e) {
                            observer.onError(new CompositeException("OnErrorResume function failed", Arrays.asList(ex, e)));
                        }
                    }
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            })));
            return new Subscription(){

                @Override
                public void unsubscribe() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            };
        }
    }
}

