/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public class OperationSkipLast {
    public static <T> Observable.OnSubscribeFunc<T> skipLast(Observable<? extends T> source, int count) {
        return new SkipLast(source, count);
    }

    public static class UnitTest {
        @Test
        public void testSkipLastEmpty() {
            Observable w = Observable.empty();
            Observable observable = Observable.create(OperationSkipLast.skipLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Matchers.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipLast1() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> observable = Observable.create(OperationSkipLast.skipLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            observable.subscribe(aObserver);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipLast2() {
            Observable<String> w = Observable.from("one", "two");
            Observable<String> observable = Observable.create(OperationSkipLast.skipLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Matchers.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipLastWithZeroCount() {
            Observable<String> w = Observable.from("one", "two");
            Observable<String> observable = Observable.create(OperationSkipLast.skipLast(w, 0));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipLastWithNull() {
            Observable<String> w = Observable.from("one", null, "two");
            Observable<String> observable = Observable.create(OperationSkipLast.skipLast(w, 1));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(null);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipLastWithNegativeCount() {
            Observable<String> w = Observable.from("one");
            Observable<String> observable = Observable.create(OperationSkipLast.skipLast(w, -1));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Matchers.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any(IndexOutOfBoundsException.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }
    }

    private static class SkipLast<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int count;
        private final Observable<? extends T> source;

        private SkipLast(Observable<? extends T> source, int count) {
            this.count = count;
            this.source = source;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            if (this.count < 0) {
                throw new IndexOutOfBoundsException("count could not be negative");
            }
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.subscribe(new Observer<T>(){
                private final ReentrantLock lock = new ReentrantLock();
                private final Deque<T> deque = new LinkedList();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T value) {
                    if (SkipLast.this.count == 0) {
                        try {
                            observer.onNext(value);
                        }
                        catch (Throwable ex) {
                            observer.onError(ex);
                            subscription.unsubscribe();
                        }
                        return;
                    }
                    this.lock.lock();
                    try {
                        this.deque.offerLast(value);
                        if (this.deque.size() > SkipLast.this.count) {
                            observer.onNext(this.deque.removeFirst());
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }));
        }
    }
}

