/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationSkipWhile {
    public static <T> Observable.OnSubscribeFunc<T> skipWhileWithIndex(Observable<? extends T> source, Func2<? super T, Integer, Boolean> predicate) {
        return new SkipWhile<T>(source, predicate);
    }

    public static <T> Observable.OnSubscribeFunc<T> skipWhile(Observable<? extends T> source, final Func1<? super T, Boolean> predicate) {
        return new SkipWhile<T>(source, new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T value, Integer index) {
                return (Boolean)predicate.call(value);
            }
        });
    }

    public static class UnitTest {
        Observer<Integer> w = (Observer)Mockito.mock(Observer.class);
        private static final Func1<Integer, Boolean> LESS_THAN_FIVE = new Func1<Integer, Boolean>(){

            @Override
            public Boolean call(Integer v) {
                if (v == 42) {
                    throw new RuntimeException("that's not the answer to everything!");
                }
                return v < 5;
            }
        };
        private static final Func2<Integer, Integer, Boolean> INDEX_LESS_THAN_THREE = new Func2<Integer, Integer, Boolean>(){

            @Override
            public Boolean call(Integer value, Integer index) {
                return index < 3;
            }
        };

        @Test
        public void testSkipWithIndex() {
            Observable<Integer> src = Observable.from(1, 2, 3, 4, 5);
            Observable.create(OperationSkipWhile.skipWhileWithIndex(src, INDEX_LESS_THAN_THREE)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(4);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(5);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testSkipEmpty() {
            Observable src = Observable.empty();
            Observable.create(OperationSkipWhile.skipWhile(src, LESS_THAN_FIVE)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipEverything() {
            Observable<Integer> src = Observable.from(1, 2, 3, 4, 3, 2, 1);
            Observable.create(OperationSkipWhile.skipWhile(src, LESS_THAN_FIVE)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipNothing() {
            Observable<Integer> src = Observable.from(5, Integer.valueOf(3), 1);
            Observable.create(OperationSkipWhile.skipWhile(src, LESS_THAN_FIVE)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(5);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(3);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(1);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testSkipSome() {
            Observable<Integer> src = Observable.from(1, 2, 3, 4, 5, 3, 1, 5);
            Observable.create(OperationSkipWhile.skipWhile(src, LESS_THAN_FIVE)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(5);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(3);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(1);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(5);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testSkipError() {
            Observable<Integer> src = Observable.from(1, 2, 42, 5, 3, 1);
            Observable.create(OperationSkipWhile.skipWhile(src, LESS_THAN_FIVE)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyInt());
            ((Observer)inOrder.verify(this.w, Mockito.never())).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onError((Throwable)Mockito.any(RuntimeException.class));
        }
    }

    private static class SkipWhile<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func2<? super T, Integer, Boolean> predicate;
        private final AtomicBoolean skipping = new AtomicBoolean(true);
        private final AtomicInteger index = new AtomicInteger(0);

        SkipWhile(Observable<? extends T> source, Func2<? super T, Integer, Boolean> pred) {
            this.source = source;
            this.predicate = pred;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.source.subscribe(new SkipWhileObserver(observer));
        }

        private class SkipWhileObserver
        implements Observer<T> {
            private final Observer<? super T> observer;

            public SkipWhileObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T next) {
                if (!SkipWhile.this.skipping.get()) {
                    this.observer.onNext(next);
                } else {
                    try {
                        if (!((Boolean)SkipWhile.this.predicate.call(next, SkipWhile.this.index.getAndIncrement())).booleanValue()) {
                            SkipWhile.this.skipping.set(false);
                            this.observer.onNext(next);
                        }
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                    }
                }
            }
        }
    }
}

