/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public class OperationToObservableFuture {
    public static <T> Observable.OnSubscribeFunc<T> toObservableFuture(Future<? extends T> that) {
        return new ToObservableFuture<T>(that);
    }

    public static <T> Observable.OnSubscribeFunc<T> toObservableFuture(Future<? extends T> that, long time, TimeUnit unit) {
        return new ToObservableFuture<T>(that, time, unit);
    }

    public static class UnitTest {
        @Test
        public void testSuccess() throws Exception {
            Future future = (Future)Mockito.mock(Future.class);
            Object value = new Object();
            Mockito.when(future.get()).thenReturn(value);
            ToObservableFuture ob = new ToObservableFuture(future);
            Observer o = (Observer)Mockito.mock(Observer.class);
            Subscription sub = ob.onSubscribe(o);
            sub.unsubscribe();
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.times((int)1))).onNext(value);
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.never())).onError(null);
            ((Future)Mockito.verify((Object)future, (VerificationMode)Mockito.never())).cancel(true);
        }

        @Test
        public void testFailure() throws Exception {
            Future future = (Future)Mockito.mock(Future.class);
            RuntimeException e = new RuntimeException();
            Mockito.when(future.get()).thenThrow(new Throwable[]{e});
            ToObservableFuture ob = new ToObservableFuture(future);
            Observer o = (Observer)Mockito.mock(Observer.class);
            Subscription sub = ob.onSubscribe(o);
            sub.unsubscribe();
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.never())).onNext(null);
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)o, (VerificationMode)Mockito.times((int)1))).onError(e);
            ((Future)Mockito.verify((Object)future, (VerificationMode)Mockito.never())).cancel(true);
        }
    }

    private static class ToObservableFuture<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Future<? extends T> that;
        private final Long time;
        private final TimeUnit unit;

        public ToObservableFuture(Future<? extends T> that) {
            this.that = that;
            this.time = null;
            this.unit = null;
        }

        public ToObservableFuture(Future<? extends T> that, long time, TimeUnit unit) {
            this.that = that;
            this.time = time;
            this.unit = unit;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            try {
                T value;
                T t = value = this.time == null ? this.that.get() : this.that.get(this.time, this.unit);
                if (!this.that.isCancelled()) {
                    observer.onNext(value);
                }
                observer.onCompleted();
            }
            catch (Throwable e) {
                observer.onError(e);
            }
            return Subscriptions.empty();
        }
    }
}

