/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationToObservableList<T> {
    public static <T> Observable.OnSubscribeFunc<List<T>> toObservableList(Observable<? extends T> that) {
        return new ToObservableList<T>(that);
    }

    public static class UnitTest {
        @Test
        public void testList() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<List<String>> observable = Observable.create(OperationToObservableList.toObservableList(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(Arrays.asList("one", "two", "three"));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testListMultipleObservers() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<List<String>> observable = Observable.create(OperationToObservableList.toObservableList(w));
            Observer o1 = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(o1);
            Observer o2 = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(o2);
            List<String> expected = Arrays.asList("one", "two", "three");
            ((Observer)Mockito.verify((Object)o1, (VerificationMode)Mockito.times((int)1))).onNext(expected);
            ((Observer)Mockito.verify((Object)o1, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)o1, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)o2, (VerificationMode)Mockito.times((int)1))).onNext(expected);
            ((Observer)Mockito.verify((Object)o2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)o2, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class ToObservableList<T>
    implements Observable.OnSubscribeFunc<List<T>> {
        private final Observable<? extends T> that;

        public ToObservableList(Observable<? extends T> that) {
            this.that = that;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super List<T>> observer) {
            return this.that.subscribe(new Observer<T>(){
                final ConcurrentLinkedQueue<T> list = new ConcurrentLinkedQueue();

                @Override
                public void onNext(T value) {
                    this.list.add(value);
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    try {
                        ArrayList l = new ArrayList(this.list.size());
                        for (Object t : this.list) {
                            l.add(t);
                        }
                        observer.onNext(l);
                        observer.onCompleted();
                    }
                    catch (Throwable e) {
                        this.onError(e);
                    }
                }
            });
        }
    }
}

