/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.operators.ChunkedOperation;
import rx.subscriptions.Subscriptions;
import rx.util.Closing;
import rx.util.Closings;
import rx.util.Opening;
import rx.util.Openings;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationWindow
extends ChunkedOperation {
    public static <T> Func0<Window<T>> windowMaker() {
        return new Func0<Window<T>>(){

            @Override
            public Window<T> call() {
                return new Window();
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final Func0<? extends Observable<? extends Closing>> windowClosingSelector) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.NonOverlappingChunks windows = new ChunkedOperation.NonOverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.ObservableBasedSingleChunkCreator creator = new ChunkedOperation.ObservableBasedSingleChunkCreator(windows, windowClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final Observable<? extends Opening> windowOpenings, final Func1<Opening, ? extends Observable<? extends Closing>> windowClosingSelector) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.OverlappingChunks windows = new ChunkedOperation.OverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.ObservableBasedMultiChunkCreator creator = new ChunkedOperation.ObservableBasedMultiChunkCreator(windows, windowOpenings, windowClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, int count) {
        return OperationWindow.window(source, count, count);
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final int count, final int skip) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.SizeBasedChunks chunks = new ChunkedOperation.SizeBasedChunks(observer, OperationWindow.windowMaker(), count);
                ChunkedOperation.SkippingChunkCreator creator = new ChunkedOperation.SkippingChunkCreator(chunks, skip);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, TimeUnit unit) {
        return OperationWindow.window(source, timespan, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.NonOverlappingChunks windows = new ChunkedOperation.NonOverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(windows, timespan, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, TimeUnit unit, int count) {
        return OperationWindow.window(source, timespan, unit, count, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final TimeUnit unit, final int count, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.TimeAndSizeBasedChunks chunks = new ChunkedOperation.TimeAndSizeBasedChunks(observer, OperationWindow.windowMaker(), count, timespan, unit, scheduler);
                ChunkedOperation.SingleChunkCreator creator = new ChunkedOperation.SingleChunkCreator(chunks);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, long timeshift, TimeUnit unit) {
        return OperationWindow.window(source, timespan, timeshift, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final long timeshift, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.TimeBasedChunks windows = new ChunkedOperation.TimeBasedChunks(observer, OperationWindow.windowMaker(), timespan, unit, scheduler);
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(windows, timeshift, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static class UnitTest {
        private TestScheduler scheduler;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
        }

        private static <T> List<List<T>> toLists(Observable<Observable<T>> observable) {
            final ArrayList list = new ArrayList();
            final ArrayList<List<T>> lists = new ArrayList<List<T>>();
            observable.subscribe(new Action1<Observable<T>>(){

                @Override
                public void call(Observable<T> tObservable) {
                    tObservable.subscribe(new Action1<T>(){

                        @Override
                        public void call(T t) {
                            list.add(t);
                        }
                    });
                    lists.add(new ArrayList(list));
                    list.clear();
                }
            });
            return lists;
        }

        @Test
        public void testNonOverlappingWindows() {
            Observable<String> subject = Observable.from("one", "two", "three", "four", "five");
            Observable windowed = Observable.create(OperationWindow.window(subject, 3));
            List windows = UnitTest.toLists(windowed);
            Assert.assertEquals((long)2L, (long)windows.size());
            Assert.assertEquals(this.list("one", "two", "three"), windows.get(0));
            Assert.assertEquals(this.list("four", "five"), windows.get(1));
        }

        @Test
        public void testSkipAndCountGaplessEindows() {
            Observable<String> subject = Observable.from("one", "two", "three", "four", "five");
            Observable windowed = Observable.create(OperationWindow.window(subject, 3, 3));
            List windows = UnitTest.toLists(windowed);
            Assert.assertEquals((long)2L, (long)windows.size());
            Assert.assertEquals(this.list("one", "two", "three"), windows.get(0));
            Assert.assertEquals(this.list("four", "five"), windows.get(1));
        }

        @Test
        public void testOverlappingWindows() {
            Observable<String> subject = Observable.from("zero", "one", "two", "three", "four", "five");
            Observable windowed = Observable.create(OperationWindow.window(subject, 3, 1));
            List windows = UnitTest.toLists(windowed);
            Assert.assertEquals((long)6L, (long)windows.size());
            Assert.assertEquals(this.list("zero", "one", "two"), windows.get(0));
            Assert.assertEquals(this.list("one", "two", "three"), windows.get(1));
            Assert.assertEquals(this.list("two", "three", "four"), windows.get(2));
            Assert.assertEquals(this.list("three", "four", "five"), windows.get(3));
            Assert.assertEquals(this.list("four", "five"), windows.get(4));
            Assert.assertEquals(this.list("five"), windows.get(5));
        }

        @Test
        public void testSkipAndCountWindowsWithGaps() {
            Observable<String> subject = Observable.from("one", "two", "three", "four", "five");
            Observable windowed = Observable.create(OperationWindow.window(subject, 2, 3));
            List windows = UnitTest.toLists(windowed);
            Assert.assertEquals((long)2L, (long)windows.size());
            Assert.assertEquals(this.list("one", "two"), windows.get(0));
            Assert.assertEquals(this.list("four", "five"), windows.get(1));
        }

        @Test
        public void testTimedAndCount() {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 90);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 190);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Observable<Observable<String>> windowed = Observable.create(OperationWindow.window(source, 100L, TimeUnit.MILLISECONDS, 2, (Scheduler)this.scheduler));
            windowed.subscribe(this.observeWindow(list, lists));
            this.scheduler.advanceTimeTo(100L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)1L, (long)lists.size());
            Assert.assertEquals(lists.get(0), this.list("one", "two"));
            this.scheduler.advanceTimeTo(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)2L, (long)lists.size());
            Assert.assertEquals(lists.get(1), this.list("three", "four"));
            this.scheduler.advanceTimeTo(300L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)3L, (long)lists.size());
            Assert.assertEquals(lists.get(2), this.list("five"));
        }

        @Test
        public void testTimed() {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 98);
                    UnitTest.this.push(observer, "two", 99);
                    UnitTest.this.push(observer, "three", 100);
                    UnitTest.this.push(observer, "four", 101);
                    UnitTest.this.push(observer, "five", 102);
                    UnitTest.this.complete(observer, 150);
                    return Subscriptions.empty();
                }
            });
            Observable<Observable<String>> windowed = Observable.create(OperationWindow.window(source, 100L, TimeUnit.MILLISECONDS, this.scheduler));
            windowed.subscribe(this.observeWindow(list, lists));
            this.scheduler.advanceTimeTo(101L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)1L, (long)lists.size());
            Assert.assertEquals(lists.get(0), this.list("one", "two", "three"));
            this.scheduler.advanceTimeTo(201L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)2L, (long)lists.size());
            Assert.assertEquals(lists.get(1), this.list("four", "five"));
        }

        @Test
        public void testObservableBasedOpenerAndCloser() {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 60);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 160);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 500);
                    return Subscriptions.empty();
                }
            });
            Observable<Opening> openings = Observable.create(new Observable.OnSubscribeFunc<Opening>(){

                @Override
                public Subscription onSubscribe(Observer<? super Opening> observer) {
                    UnitTest.this.push(observer, Openings.create(), 50);
                    UnitTest.this.push(observer, Openings.create(), 200);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Func1<Opening, Observable<Closing>> closer = new Func1<Opening, Observable<Closing>>(){

                @Override
                public Observable<Closing> call(Opening opening) {
                    return Observable.create(new Observable.OnSubscribeFunc<Closing>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super Closing> observer) {
                            UnitTest.this.push(observer, Closings.create(), 100);
                            UnitTest.this.complete(observer, 101);
                            return Subscriptions.empty();
                        }
                    });
                }
            };
            Observable<Observable<String>> windowed = Observable.create(OperationWindow.window(source, openings, (Func1<Opening, ? extends Observable<? extends Closing>>)closer));
            windowed.subscribe(this.observeWindow(list, lists));
            this.scheduler.advanceTimeTo(500L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)2L, (long)lists.size());
            Assert.assertEquals(lists.get(0), this.list("two", "three"));
            Assert.assertEquals(lists.get(1), this.list("five"));
        }

        @Test
        public void testObservableBasedCloser() {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 60);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 160);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Func0<Observable<Closing>> closer = new Func0<Observable<Closing>>(){

                @Override
                public Observable<Closing> call() {
                    return Observable.create(new Observable.OnSubscribeFunc<Closing>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super Closing> observer) {
                            UnitTest.this.push(observer, Closings.create(), 100);
                            UnitTest.this.complete(observer, 101);
                            return Subscriptions.empty();
                        }
                    });
                }
            };
            Observable<Observable<String>> windowed = Observable.create(OperationWindow.window(source, (Func0<? extends Observable<? extends Closing>>)closer));
            windowed.subscribe(this.observeWindow(list, lists));
            this.scheduler.advanceTimeTo(500L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)3L, (long)lists.size());
            Assert.assertEquals(lists.get(0), this.list("one", "two"));
            Assert.assertEquals(lists.get(1), this.list("three", "four"));
            Assert.assertEquals(lists.get(2), this.list("five"));
        }

        private List<String> list(String ... args) {
            ArrayList<String> list = new ArrayList<String>();
            for (String arg : args) {
                list.add(arg);
            }
            return list;
        }

        private <T> void push(final Observer<T> observer, final T value, int delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onNext(value);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private void complete(final Observer<?> observer, int delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onCompleted();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private Action1<Observable<String>> observeWindow(final List<String> list, final List<List<String>> lists) {
            return new Action1<Observable<String>>(){

                @Override
                public void call(Observable<String> stringObservable) {
                    stringObservable.subscribe(new Observer<String>(){

                        @Override
                        public void onCompleted() {
                            lists.add(new ArrayList(list));
                            list.clear();
                        }

                        @Override
                        public void onError(Throwable e) {
                            Assert.fail((String)e.getMessage());
                        }

                        @Override
                        public void onNext(String args) {
                            list.add(args);
                        }
                    });
                }
            };
        }
    }

    protected static class Window<T>
    extends ChunkedOperation.Chunk<T, Observable<T>> {
        protected Window() {
        }

        @Override
        public Observable<T> getContents() {
            return Observable.from(this.contents);
        }
    }
}

