/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Functions;

public final class OperationZip {
    public static <T1, T2, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        return a;
    }

    public static <T1, T2, T3, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        return a;
    }

    public static <T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        return a;
    }

    public static <T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        ((Aggregator)a).addObserver(new ZipObserver<R, T5>(a, o5));
        return a;
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        ((Aggregator)a).addObserver(new ZipObserver<R, T5>(a, o5));
        ((Aggregator)a).addObserver(new ZipObserver<R, T6>(a, o6));
        return a;
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        ((Aggregator)a).addObserver(new ZipObserver<R, T5>(a, o5));
        ((Aggregator)a).addObserver(new ZipObserver<R, T6>(a, o6));
        ((Aggregator)a).addObserver(new ZipObserver<R, T7>(a, o7));
        return a;
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        ((Aggregator)a).addObserver(new ZipObserver<R, T5>(a, o5));
        ((Aggregator)a).addObserver(new ZipObserver<R, T6>(a, o6));
        ((Aggregator)a).addObserver(new ZipObserver<R, T7>(a, o7));
        ((Aggregator)a).addObserver(new ZipObserver<R, T8>(a, o8));
        return a;
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(Functions.fromFunc(zipFunction));
        ((Aggregator)a).addObserver(new ZipObserver<R, T1>(a, o1));
        ((Aggregator)a).addObserver(new ZipObserver<R, T2>(a, o2));
        ((Aggregator)a).addObserver(new ZipObserver<R, T3>(a, o3));
        ((Aggregator)a).addObserver(new ZipObserver<R, T4>(a, o4));
        ((Aggregator)a).addObserver(new ZipObserver<R, T5>(a, o5));
        ((Aggregator)a).addObserver(new ZipObserver<R, T6>(a, o6));
        ((Aggregator)a).addObserver(new ZipObserver<R, T7>(a, o7));
        ((Aggregator)a).addObserver(new ZipObserver<R, T8>(a, o8));
        ((Aggregator)a).addObserver(new ZipObserver<R, T9>(a, o9));
        return a;
    }

    public static <R> Observable.OnSubscribeFunc<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        Aggregator<? extends R> a = new Aggregator<R>(zipFunction);
        for (Observable<?> w : ws) {
            ZipObserver zipObserver = new ZipObserver(a, w);
            ((Aggregator)a).addObserver(zipObserver);
        }
        return a;
    }

    public static class UnitTest {
        @Test
        public void testCollectionSizeDifferentThanFunction() {
            FuncN<String> zipr = Functions.fromFunc(this.getConcatStringIntegerIntArrayZipr());
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Set<Observable<String>> ws = Collections.singleton(Observable.from("one", "two"));
            Observable<String> w = Observable.create(OperationZip.zip(ws, zipr));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.any(String.class));
        }

        @Test
        public void testZippingDifferentLengthObservableSequences1() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            TestObservable w3 = new TestObservable();
            Observable<String> zipW = Observable.create(OperationZip.zip(Observable.create(w1), Observable.create(w2), Observable.create(w3), this.getConcat3StringsZipr()));
            zipW.subscribe(w);
            w1.observer.onNext("1a");
            w1.observer.onCompleted();
            w2.observer.onNext("2a");
            w2.observer.onNext("2b");
            w2.observer.onCompleted();
            w3.observer.onNext("3a");
            w3.observer.onNext("3b");
            w3.observer.onNext("3c");
            w3.observer.onNext("3d");
            w3.observer.onCompleted();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{w});
            ((Observer)inOrder.verify((Object)w)).onNext("1a2a3a");
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testZippingDifferentLengthObservableSequences2() {
            Observer w = (Observer)Mockito.mock(Observer.class);
            TestObservable w1 = new TestObservable();
            TestObservable w2 = new TestObservable();
            TestObservable w3 = new TestObservable();
            Observable<String> zipW = Observable.create(OperationZip.zip(Observable.create(w1), Observable.create(w2), Observable.create(w3), this.getConcat3StringsZipr()));
            zipW.subscribe(w);
            w1.observer.onNext("1a");
            w1.observer.onNext("1b");
            w1.observer.onNext("1c");
            w1.observer.onNext("1d");
            w1.observer.onCompleted();
            w2.observer.onNext("2a");
            w2.observer.onNext("2b");
            w2.observer.onCompleted();
            w3.observer.onNext("3a");
            w3.observer.onCompleted();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{w});
            ((Observer)inOrder.verify((Object)w)).onNext("1a2a3a");
            ((Observer)inOrder.verify((Object)w, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorSimple() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hello ");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("hello again");
            a.complete(r1);
            a.complete(r2);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorDifferentSizedResultsWithOnComplete() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            a.complete(r2);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hi");
            a.complete(r1);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
        }

        @Test
        public void testAggregateMultipleTypes() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            a.complete(r2);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("helloworld");
            a.next(r1, "hi");
            a.complete(r1);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
        }

        @Test
        public void testAggregate3Types() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r3 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            ((Aggregator)a).addObserver(r3);
            a.next(r1, "hello");
            a.next(r2, 2);
            a.next(r3, new int[]{5, 6, 7});
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("hello2[5, 6, 7]");
        }

        @Test
        public void testAggregatorsWithDifferentSizesAndTiming() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "one");
            a.next(r1, "two");
            a.next(r1, "three");
            a.next(r2, "A");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("oneA");
            a.next(r1, "four");
            a.complete(r1);
            a.next(r2, "B");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("twoB");
            a.next(r2, "C");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeC");
            a.next(r2, "D");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("fourD");
            a.next(r2, "E");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("E");
            a.complete(r2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testAggregatorError() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            a.error(r1, new RuntimeException(""));
            a.next(r1, "hello");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext("helloagain");
        }

        @Test
        public void testAggregatorUnsubscribe() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Subscription subscription = a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "hello");
            a.next(r2, "world");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("helloworld");
            subscription.unsubscribe();
            a.next(r1, "hello");
            a.next(r2, "again");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)0))).onNext("helloagain");
        }

        @Test
        public void testAggregatorEarlyCompletion() {
            FuncN<String> zipr = this.getConcatZipr();
            Aggregator<String> a = new Aggregator<String>(zipr);
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            a.onSubscribe(aObserver);
            ZipObserver r1 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ZipObserver r2 = (ZipObserver)Mockito.mock(ZipObserver.class);
            ((Aggregator)a).addObserver(r1);
            ((Aggregator)a).addObserver(r2);
            a.next(r1, "one");
            a.next(r1, "two");
            a.complete(r1);
            a.next(r2, "A");
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("oneA");
            a.complete(r2);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify((Object)aObserver, Mockito.never())).onNext(Mockito.anyString());
        }

        @Test
        public void testZip2Types() {
            Func2<String, Integer, String> zipr = this.getConcatStringIntegerZipr();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> w = Observable.create(OperationZip.zip(Observable.from("one", "two"), Observable.from(2, Integer.valueOf(3), 4), zipr));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one2");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two3");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("4");
        }

        @Test
        public void testZip3Types() {
            Func3<String, Integer, int[], String> zipr = this.getConcatStringIntegerIntArrayZipr();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<String> w = Observable.create(OperationZip.zip(Observable.from("one", "two"), Observable.from(2), Observable.from(new int[]{4, 5, 6}), zipr));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one2[4, 5, 6]");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
        }

        @Test
        public void testOnNextExceptionInvokesOnError() {
            Func2<Integer, Integer, Integer> zipr = this.getDivideZipr();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Observable<Integer> w = Observable.create(OperationZip.zip(Observable.from(10, Integer.valueOf(20), 30), Observable.from(0, Integer.valueOf(1), 2), zipr));
            w.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(Throwable.class));
        }

        private Func2<Integer, Integer, Integer> getDivideZipr() {
            Func2<Integer, Integer, Integer> zipr = new Func2<Integer, Integer, Integer>(){

                @Override
                public Integer call(Integer i1, Integer i2) {
                    return i1 / i2;
                }
            };
            return zipr;
        }

        private Func3<String, String, String, String> getConcat3StringsZipr() {
            Func3<String, String, String, String> zipr = new Func3<String, String, String, String>(){

                @Override
                public String call(String a1, String a2, String a3) {
                    if (a1 == null) {
                        a1 = "";
                    }
                    if (a2 == null) {
                        a2 = "";
                    }
                    if (a3 == null) {
                        a3 = "";
                    }
                    return a1 + a2 + a3;
                }
            };
            return zipr;
        }

        private FuncN<String> getConcatZipr() {
            FuncN<String> zipr = new FuncN<String>(){

                @Override
                public String call(Object ... args) {
                    String returnValue = "";
                    for (Object o : args) {
                        if (o == null) continue;
                        returnValue = returnValue + UnitTest.getStringValue(o);
                    }
                    System.out.println("returning: " + returnValue);
                    return returnValue;
                }
            };
            return zipr;
        }

        private Func2<String, Integer, String> getConcatStringIntegerZipr() {
            Func2<String, Integer, String> zipr = new Func2<String, Integer, String>(){

                @Override
                public String call(String s, Integer i) {
                    return UnitTest.getStringValue(s) + UnitTest.getStringValue(i);
                }
            };
            return zipr;
        }

        private Func3<String, Integer, int[], String> getConcatStringIntegerIntArrayZipr() {
            Func3<String, Integer, int[], String> zipr = new Func3<String, Integer, int[], String>(){

                @Override
                public String call(String s, Integer i, int[] iArray) {
                    return UnitTest.getStringValue(s) + UnitTest.getStringValue(i) + UnitTest.getStringValue(iArray);
                }
            };
            return zipr;
        }

        private static String getStringValue(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof int[]) {
                return Arrays.toString((int[])o);
            }
            return String.valueOf(o);
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            Observer<? super String> observer;

            private TestObservable() {
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> Observer2) {
                this.observer = Observer2;
                return Subscriptions.empty();
            }
        }
    }

    private static class Aggregator<T>
    implements Observable.OnSubscribeFunc<T> {
        private volatile SynchronizedObserver<T> observer;
        private final FuncN<? extends T> zipFunction;
        private final AtomicBoolean started = new AtomicBoolean(false);
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final ConcurrentHashMap<ZipObserver<T, ?>, Boolean> completed = new ConcurrentHashMap();
        private ConcurrentHashMap<ZipObserver<T, ?>, ConcurrentLinkedQueue<Object>> receivedValuesPerObserver = new ConcurrentHashMap();
        private ConcurrentLinkedQueue<ZipObserver<T, ?>> observers = new ConcurrentLinkedQueue();

        public Aggregator(FuncN<? extends T> zipFunction) {
            this.zipFunction = zipFunction;
        }

        private void addObserver(ZipObserver<T, ?> w) {
            this.observers.add(w);
            this.receivedValuesPerObserver.put(w, new ConcurrentLinkedQueue());
        }

        void complete(ZipObserver<T, ?> w) {
            this.completed.put(w, Boolean.TRUE);
            if (this.completed.size() == this.observers.size() && this.running.compareAndSet(true, false)) {
                this.observer.onCompleted();
            }
        }

        void error(ZipObserver<T, ?> w, Throwable e) {
            if (this.running.compareAndSet(true, false)) {
                this.observer.onError(e);
                this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next(ZipObserver<T, ?> w, Object arg) {
            if (this.observer == null) {
                throw new RuntimeException("This shouldn't be running if a Observer isn't registered");
            }
            if (!this.running.get()) {
                return;
            }
            this.receivedValuesPerObserver.get(w).add(arg);
            Object[] argsToZip = new Object[this.observers.size()];
            Aggregator aggregator = this;
            synchronized (aggregator) {
                for (ZipObserver rw : this.receivedValuesPerObserver.keySet()) {
                    if (this.receivedValuesPerObserver.get(rw).peek() != null) continue;
                    return;
                }
                int i = 0;
                for (ZipObserver<T, ?> rw : this.observers) {
                    argsToZip[i++] = this.receivedValuesPerObserver.get(rw).remove();
                }
            }
            this.observer.onNext(this.zipFunction.call(argsToZip));
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.started.compareAndSet(false, true)) {
                SafeObservableSubscription subscription = new SafeObservableSubscription();
                this.observer = new SynchronizedObserver<T>(observer, subscription);
                for (ZipObserver<T, ?> rw : this.observers) {
                    rw.startWatching();
                }
                return subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        Aggregator.this.stop();
                    }
                });
            }
            throw new IllegalStateException("Only one Observer can subscribe to this Observable.");
        }

        private void stop() {
            if (this.running.compareAndSet(true, false)) {
                for (ZipObserver<T, ?> o : this.observers) {
                    if (((ZipObserver)o).subscription == null) continue;
                    ((ZipObserver)o).subscription.unsubscribe();
                }
            }
        }
    }

    private static class ZipObserver<R, T>
    implements Observer<T> {
        final Observable<? extends T> w;
        final Aggregator<R> a;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();
        private final AtomicBoolean subscribed = new AtomicBoolean(false);

        public ZipObserver(Aggregator<R> a, Observable<? extends T> w) {
            this.a = a;
            this.w = w;
        }

        public void startWatching() {
            if (this.subscribed.compareAndSet(false, true)) {
                this.subscription.wrap(this.w.subscribe(this));
            }
        }

        @Override
        public void onCompleted() {
            this.a.complete(this);
        }

        @Override
        public void onError(Throwable e) {
            this.a.error(this, e);
        }

        @Override
        public void onNext(T args) {
            try {
                this.a.next(this, args);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }
    }
}

