/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import rx.plugins.RxJavaErrorHandler;
import rx.plugins.RxJavaErrorHandlerDefault;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaObservableExecutionHookDefault;

public class RxJavaPlugins {
    private static final RxJavaPlugins INSTANCE = new RxJavaPlugins();
    private final AtomicReference<RxJavaErrorHandler> errorHandler = new AtomicReference();
    private final AtomicReference<RxJavaObservableExecutionHook> observableExecutionHook = new AtomicReference();

    private RxJavaPlugins() {
    }

    public static RxJavaPlugins getInstance() {
        return INSTANCE;
    }

    public RxJavaErrorHandler getErrorHandler() {
        if (this.errorHandler.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaErrorHandler.class);
            if (impl == null) {
                this.errorHandler.compareAndSet(null, RxJavaErrorHandlerDefault.getInstance());
            } else {
                this.errorHandler.compareAndSet(null, (RxJavaErrorHandler)impl);
            }
        }
        return this.errorHandler.get();
    }

    public void registerErrorHandler(RxJavaErrorHandler impl) {
        if (!this.errorHandler.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public RxJavaObservableExecutionHook getObservableExecutionHook() {
        if (this.observableExecutionHook.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaObservableExecutionHook.class);
            if (impl == null) {
                this.observableExecutionHook.compareAndSet(null, RxJavaObservableExecutionHookDefault.getInstance());
            } else {
                this.observableExecutionHook.compareAndSet(null, (RxJavaObservableExecutionHook)impl);
            }
        }
        return this.observableExecutionHook.get();
    }

    public void registerObservableExecutionHook(RxJavaObservableExecutionHook impl) {
        if (!this.observableExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    private static Object getPluginImplementationViaProperty(Class<?> pluginClass) {
        String classSimpleName = pluginClass.getSimpleName();
        String implementingClass = System.getProperty("rxjava.plugin." + classSimpleName + ".implementation");
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(classSimpleName + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }

    public static class UnitTest {
        @Test
        public void testErrorHandlerDefaultImpl() {
            RxJavaErrorHandler impl = new RxJavaPlugins().getErrorHandler();
            Assert.assertTrue((boolean)(impl instanceof RxJavaErrorHandlerDefault));
        }

        @Test
        public void testErrorHandlerViaRegisterMethod() {
            RxJavaPlugins p = new RxJavaPlugins();
            p.registerErrorHandler(new RxJavaErrorHandlerTestImpl());
            RxJavaErrorHandler impl = p.getErrorHandler();
            Assert.assertTrue((boolean)(impl instanceof RxJavaErrorHandlerTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testErrorHandlerViaProperty() {
            try {
                RxJavaPlugins p = new RxJavaPlugins();
                String fullClass = UnitTest.getFullClassNameForTestClass(RxJavaErrorHandlerTestImpl.class);
                System.setProperty("rxjava.plugin.RxJavaErrorHandler.implementation", fullClass);
                RxJavaErrorHandler impl = p.getErrorHandler();
                Assert.assertTrue((boolean)(impl instanceof RxJavaErrorHandlerTestImpl));
            }
            finally {
                System.clearProperty("rxjava.plugin.RxJavaErrorHandler.implementation");
            }
        }

        @Test
        public void testObservableExecutionHookDefaultImpl() {
            RxJavaPlugins p = new RxJavaPlugins();
            RxJavaObservableExecutionHook impl = p.getObservableExecutionHook();
            Assert.assertTrue((boolean)(impl instanceof RxJavaObservableExecutionHookDefault));
        }

        @Test
        public void testObservableExecutionHookViaRegisterMethod() {
            RxJavaPlugins p = new RxJavaPlugins();
            p.registerObservableExecutionHook(new RxJavaObservableExecutionHookTestImpl());
            RxJavaObservableExecutionHook impl = p.getObservableExecutionHook();
            Assert.assertTrue((boolean)(impl instanceof RxJavaObservableExecutionHookTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testObservableExecutionHookViaProperty() {
            try {
                RxJavaPlugins p = new RxJavaPlugins();
                String fullClass = UnitTest.getFullClassNameForTestClass(RxJavaObservableExecutionHookTestImpl.class);
                System.setProperty("rxjava.plugin.RxJavaObservableExecutionHook.implementation", fullClass);
                RxJavaObservableExecutionHook impl = p.getObservableExecutionHook();
                Assert.assertTrue((boolean)(impl instanceof RxJavaObservableExecutionHookTestImpl));
            }
            finally {
                System.clearProperty("rxjava.plugin.RxJavaObservableExecutionHook.implementation");
            }
        }

        private static String getFullClassNameForTestClass(Class<?> cls) {
            return RxJavaPlugins.class.getPackage().getName() + "." + RxJavaPlugins.class.getSimpleName() + "$UnitTest$" + cls.getSimpleName();
        }

        public static class RxJavaObservableExecutionHookTestImpl
        extends RxJavaObservableExecutionHook {
        }

        public static class RxJavaErrorHandlerTestImpl
        extends RxJavaErrorHandler {
        }
    }
}

