/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;
import rx.subjects.UnsubscribeTester;
import rx.util.functions.Action1;
import rx.util.functions.Func0;

public class AsyncSubject<T>
extends Subject<T, T> {
    private final ConcurrentHashMap<Subscription, Observer<? super T>> observers;
    private final AtomicReference<T> currentValue;

    public static <T> AsyncSubject<T> create() {
        final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap<Subscription, Observer<? super T>>();
        Observable.OnSubscribeFunc onSubscribe = new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        observers.remove(subscription);
                    }
                });
                observers.put(subscription, observer);
                return subscription;
            }
        };
        return new AsyncSubject<T>(onSubscribe, observers);
    }

    protected AsyncSubject(Observable.OnSubscribeFunc<T> onSubscribe, ConcurrentHashMap<Subscription, Observer<? super T>> observers) {
        super(onSubscribe);
        this.observers = observers;
        this.currentValue = new AtomicReference();
    }

    @Override
    public void onCompleted() {
        T finalValue = this.currentValue.get();
        for (Observer<T> observer : this.observers.values()) {
            observer.onNext(finalValue);
        }
        for (Observer<T> observer : this.observers.values()) {
            observer.onCompleted();
        }
    }

    @Override
    public void onError(Throwable e) {
        for (Observer<T> observer : this.observers.values()) {
            observer.onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        this.currentValue.set(args);
    }

    public static class UnitTest {
        private final Throwable testException = new Throwable();

        @Test
        public void testNeverCompleted() {
            AsyncSubject<String> subject = AsyncSubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            this.assertNeverCompletedObserver(aObserver);
        }

        private void assertNeverCompletedObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError(this.testException);
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testCompleted() {
            AsyncSubject<String> subject = AsyncSubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            subject.onCompleted();
            this.assertCompletedObserver(aObserver);
        }

        private void assertCompletedObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testError() {
            AsyncSubject<String> subject = AsyncSubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            subject.onError(this.testException);
            subject.onNext("four");
            subject.onError(new Throwable());
            subject.onCompleted();
            this.assertErrorObserver(aObserver);
        }

        private void assertErrorObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onError(this.testException);
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testUnsubscribeBeforeCompleted() {
            AsyncSubject<String> subject = AsyncSubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Subscription subscription = subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subscription.unsubscribe();
            this.assertNoOnNextEventsReceived(aObserver);
            subject.onNext("three");
            subject.onCompleted();
            this.assertNoOnNextEventsReceived(aObserver);
        }

        private void assertNoOnNextEventsReceived(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testUnsubscribe() {
            UnsubscribeTester.test(new Func0<AsyncSubject<Object>>(){

                @Override
                public AsyncSubject<Object> call() {
                    return AsyncSubject.create();
                }
            }, new Action1<AsyncSubject<Object>>(){

                @Override
                public void call(AsyncSubject<Object> DefaultSubject) {
                    DefaultSubject.onCompleted();
                }
            }, new Action1<AsyncSubject<Object>>(){

                @Override
                public void call(AsyncSubject<Object> DefaultSubject) {
                    DefaultSubject.onError(new Throwable());
                }
            }, null);
        }
    }
}

