/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subjects.Subject;
import rx.subjects.UnsubscribeTester;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action1;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class ReplaySubject<T>
extends Subject<T, T> {
    private boolean isDone = false;
    private Throwable exception = null;
    private final Map<Subscription, Observer<? super T>> subscriptions = new HashMap<Subscription, Observer<? super T>>();
    private final List<T> history = Collections.synchronizedList(new ArrayList());

    public static <T> ReplaySubject<T> create() {
        return new ReplaySubject(new DelegateSubscriptionFunc());
    }

    private ReplaySubject(DelegateSubscriptionFunc<T> onSubscribe) {
        super(onSubscribe);
        onSubscribe.wrap(new SubscriptionFunc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        Map<Subscription, Observer<? super T>> map = this.subscriptions;
        synchronized (map) {
            this.isDone = true;
            for (Observer<T> observer : new ArrayList<Observer<T>>(this.subscriptions.values())) {
                observer.onCompleted();
            }
            this.subscriptions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        Map<Subscription, Observer<? super T>> map = this.subscriptions;
        synchronized (map) {
            if (this.isDone) {
                return;
            }
            this.isDone = true;
            this.exception = e;
            for (Observer<T> observer : new ArrayList<Observer<T>>(this.subscriptions.values())) {
                observer.onError(e);
            }
            this.subscriptions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T args) {
        Map<Subscription, Observer<? super T>> map = this.subscriptions;
        synchronized (map) {
            this.history.add(args);
            for (Observer<T> observer : new ArrayList<Observer<T>>(this.subscriptions.values())) {
                observer.onNext(args);
            }
        }
    }

    public static class UnitTest {
        private final Throwable testException = new Throwable();

        @Test
        public void testCompleted() {
            ReplaySubject<String> subject = ReplaySubject.create();
            Observer o1 = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(o1);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            subject.onCompleted();
            subject.onNext("four");
            subject.onCompleted();
            subject.onError(new Throwable());
            this.assertCompletedObserver(o1);
            Observer o2 = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(o2);
            this.assertCompletedObserver(o2);
        }

        private void assertCompletedObserver(Observer<String> aObserver) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            ((Observer)inOrder.verify(aObserver, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify(aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify(aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify(aObserver, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(aObserver, Mockito.times((int)1))).onCompleted();
            inOrder.verifyNoMoreInteractions();
        }

        @Test
        public void testError() {
            ReplaySubject<String> subject = ReplaySubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subject.onNext("three");
            subject.onError(this.testException);
            subject.onNext("four");
            subject.onError(new Throwable());
            subject.onCompleted();
            this.assertErrorObserver(aObserver);
            aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            this.assertErrorObserver(aObserver);
        }

        private void assertErrorObserver(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onError(this.testException);
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testSubscribeMidSequence() {
            ReplaySubject<String> subject = ReplaySubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            this.assertObservedUntilTwo(aObserver);
            Observer anotherObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(anotherObserver);
            this.assertObservedUntilTwo(anotherObserver);
            subject.onNext("three");
            subject.onCompleted();
            this.assertCompletedObserver(aObserver);
            this.assertCompletedObserver(anotherObserver);
        }

        @Test
        public void testUnsubscribeFirstObserver() {
            ReplaySubject<String> subject = ReplaySubject.create();
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            Subscription subscription = subject.subscribe(aObserver);
            subject.onNext("one");
            subject.onNext("two");
            subscription.unsubscribe();
            this.assertObservedUntilTwo(aObserver);
            Observer anotherObserver = (Observer)Mockito.mock(Observer.class);
            subject.subscribe(anotherObserver);
            this.assertObservedUntilTwo(anotherObserver);
            subject.onNext("three");
            subject.onCompleted();
            this.assertObservedUntilTwo(aObserver);
            this.assertCompletedObserver(anotherObserver);
        }

        private void assertObservedUntilTwo(Observer<String> aObserver) {
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(aObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testUnsubscribe() {
            UnsubscribeTester.test(new Func0<ReplaySubject<Object>>(){

                @Override
                public ReplaySubject<Object> call() {
                    return ReplaySubject.create();
                }
            }, new Action1<ReplaySubject<Object>>(){

                @Override
                public void call(ReplaySubject<Object> repeatSubject) {
                    repeatSubject.onCompleted();
                }
            }, new Action1<ReplaySubject<Object>>(){

                @Override
                public void call(ReplaySubject<Object> repeatSubject) {
                    repeatSubject.onError(new Throwable());
                }
            }, new Action1<ReplaySubject<Object>>(){

                @Override
                public void call(ReplaySubject<Object> repeatSubject) {
                    repeatSubject.onNext("one");
                }
            });
        }
    }

    private class RepeatSubjectSubscription
    implements Subscription {
        private RepeatSubjectSubscription() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe() {
            Map map = ReplaySubject.this.subscriptions;
            synchronized (map) {
                ReplaySubject.this.subscriptions.remove(this);
            }
        }
    }

    private class SubscriptionFunc
    implements Func1<Observer<? super T>, Subscription> {
        private SubscriptionFunc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Subscription call(Observer<? super T> observer) {
            int item = 0;
            while (true) {
                if (item < ReplaySubject.this.history.size()) {
                    observer.onNext(ReplaySubject.this.history.get(item++));
                    continue;
                }
                Map map = ReplaySubject.this.subscriptions;
                synchronized (map) {
                    if (item >= ReplaySubject.this.history.size()) break;
                }
            }
            {
                if (ReplaySubject.this.exception != null) {
                    observer.onError(ReplaySubject.this.exception);
                    return Subscriptions.empty();
                }
                if (ReplaySubject.this.isDone) {
                    observer.onCompleted();
                    return Subscriptions.empty();
                }
                RepeatSubjectSubscription subscription = new RepeatSubjectSubscription();
                ReplaySubject.this.subscriptions.put(subscription, observer);
                return subscription;
            }
        }
    }

    private static final class DelegateSubscriptionFunc<T>
    implements Observable.OnSubscribeFunc<T> {
        private Func1<? super Observer<? super T>, ? extends Subscription> delegate = null;

        private DelegateSubscriptionFunc() {
        }

        public void wrap(Func1<? super Observer<? super T>, ? extends Subscription> delegate) {
            if (this.delegate != null) {
                throw new UnsupportedOperationException("delegate already set");
            }
            this.delegate = delegate;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.delegate.call(observer);
        }
    }
}

