/*
 * Decompiled with CFR 0.152.
 */
package rx.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public final class Range
implements Iterable<Integer> {
    private final int start;
    private final int end;
    private final int step;

    public static Range createWithCount(int start, int count) {
        return Range.create(start, start + count);
    }

    public static Range create(int start, int end) {
        return new Range(start, end, 1);
    }

    public static Range createWithStep(int start, int end, int step) {
        return new Range(start, end, step);
    }

    private Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int current;
            {
                this.current = Range.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current < Range.this.end;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                int result = this.current;
                this.current += Range.this.step;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read only iterator");
            }
        };
    }

    public String toString() {
        return "Range (" + this.start + ", " + this.end + "), step " + this.step;
    }

    public static class UnitTest {
        @Test
        public void testSimpleRange() {
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4), UnitTest.toList(Range.create(1, 5)));
        }

        @Test
        public void testRangeWithStep() {
            Assert.assertEquals(Arrays.asList(1, 3, 5, 7, 9), UnitTest.toList(Range.createWithStep(1, 10, 2)));
        }

        @Test
        public void testRangeWithCount() {
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), UnitTest.toList(Range.createWithCount(1, 5)));
        }

        @Test
        public void testRangeWithCount2() {
            Assert.assertEquals(Arrays.asList(2, 3, 4, 5), UnitTest.toList(Range.createWithCount(2, 4)));
        }

        @Test
        public void testRangeWithCount3() {
            Assert.assertEquals(Arrays.asList(0, 1, 2, 3), UnitTest.toList(Range.createWithCount(0, 4)));
        }

        @Test
        public void testRangeWithCount4() {
            Assert.assertEquals(Arrays.asList(10, 11, 12, 13, 14), UnitTest.toList(Range.createWithCount(10, 5)));
        }

        private static <T> List<T> toList(Iterable<T> iterable) {
            ArrayList<T> result = new ArrayList<T>();
            for (T element : iterable) {
                result.add(element);
            }
            return result;
        }
    }
}

