/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;

public final class OperationThrottleFirst {
    public static <T> Observable.OnSubscribeFunc<T> throttleFirst(Observable<T> items, long windowDuration, TimeUnit unit) {
        return OperationThrottleFirst.throttleFirst(items, windowDuration, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> throttleFirst(final Observable<T> items, final long windowDuration, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final AtomicLong lastOnNext = new AtomicLong(0L);
                final long timeInMilliseconds = unit.toMillis(windowDuration);
                return items.filter(new Func1<T, Boolean>(){

                    @Override
                    public Boolean call(T value) {
                        long now = scheduler.now();
                        if (lastOnNext.get() == 0L || now - lastOnNext.get() >= timeInMilliseconds) {
                            lastOnNext.set(now);
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                }).subscribe(observer);
            }
        };
    }

    public static class UnitTest {
        private TestScheduler scheduler;
        private Observer<String> observer;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
            this.observer = (Observer)Mockito.mock(Observer.class);
        }

        @Test
        public void testThrottlingWithCompleted() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.publishNext(observer, 100L, "one");
                    UnitTest.this.publishNext(observer, 300L, "two");
                    UnitTest.this.publishNext(observer, 900L, "three");
                    UnitTest.this.publishNext(observer, 905L, "four");
                    UnitTest.this.publishCompleted(observer, 1000L);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationThrottleFirst.throttleFirst(source, 400L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(1000L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("one");
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)0))).onNext("two");
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("three");
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)0))).onNext("four");
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
            inOrder.verifyNoMoreInteractions();
        }

        @Test
        public void testThrottlingWithError() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    TestException error = new TestException();
                    UnitTest.this.publishNext(observer, 100L, "one");
                    UnitTest.this.publishNext(observer, 200L, "two");
                    UnitTest.this.publishError(observer, 300L, error);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationThrottleFirst.throttleFirst(source, 400L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(400L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer)).onNext("one");
            ((Observer)inOrder.verify(this.observer)).onError((Throwable)Mockito.any(TestException.class));
            inOrder.verifyNoMoreInteractions();
        }

        private <T> void publishCompleted(final Observer<T> observer, long delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onCompleted();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishError(final Observer<T> observer, long delay, final Exception error) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onError(error);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishNext(final Observer<T> observer, long delay, final T value) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onNext(value);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private class TestException
        extends Exception {
            private TestException() {
            }
        }
    }
}

