/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Subscription;

public final class SafeObservableSubscription
implements Subscription {
    private static final Subscription UNSUBSCRIBED = new Subscription(){

        @Override
        public void unsubscribe() {
        }
    };
    private final AtomicReference<Subscription> actualSubscription = new AtomicReference();

    public SafeObservableSubscription() {
    }

    public SafeObservableSubscription(Subscription actualSubscription) {
        this.actualSubscription.set(actualSubscription);
    }

    public SafeObservableSubscription wrap(Subscription actualSubscription) {
        if (!this.actualSubscription.compareAndSet(null, actualSubscription)) {
            if (this.actualSubscription.get() == UNSUBSCRIBED) {
                actualSubscription.unsubscribe();
                return this;
            }
            throw new IllegalStateException("Can not set subscription more than once.");
        }
        return this;
    }

    @Override
    public void unsubscribe() {
        Subscription actual = this.actualSubscription.getAndSet(UNSUBSCRIBED);
        if (actual != null) {
            actual.unsubscribe();
        }
    }

    public boolean isUnsubscribed() {
        return this.actualSubscription.get() == UNSUBSCRIBED;
    }

    public static class UnitTest {
        @Test
        public void testWrapAfterUnsubscribe() {
            SafeObservableSubscription atomicObservableSubscription = new SafeObservableSubscription();
            atomicObservableSubscription.unsubscribe();
            Subscription innerSubscription = (Subscription)Mockito.mock(Subscription.class);
            atomicObservableSubscription.wrap(innerSubscription);
            ((Subscription)Mockito.verify((Object)innerSubscription, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }
    }
}

