/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.DiscardableAction;
import rx.concurrency.SleepingAction;
import rx.util.functions.Func2;

public class CurrentThreadScheduler
extends Scheduler {
    private static final CurrentThreadScheduler INSTANCE = new CurrentThreadScheduler();
    private static final ThreadLocal<PriorityQueue<TimedAction>> QUEUE = new ThreadLocal();
    private final AtomicInteger counter = new AtomicInteger(0);

    public static CurrentThreadScheduler getInstance() {
        return INSTANCE;
    }

    CurrentThreadScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        this.enqueue(discardableAction, this.now());
        return discardableAction;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        long execTime = this.now() + unit.toMillis(dueTime);
        DiscardableAction<T> discardableAction = new DiscardableAction<T>(state, new SleepingAction<T>(action, this, execTime));
        this.enqueue(discardableAction, execTime);
        return discardableAction;
    }

    private void enqueue(DiscardableAction<?> action, long execTime) {
        boolean exec;
        PriorityQueue<TimedAction> queue = QUEUE.get();
        boolean bl = exec = queue == null;
        if (exec) {
            queue = new PriorityQueue();
            QUEUE.set(queue);
        }
        queue.add(new TimedAction(action, execTime, this.counter.incrementAndGet()));
        if (exec) {
            while (!queue.isEmpty()) {
                queue.poll().action.call(this);
            }
            QUEUE.set(null);
        }
    }

    private static class TimedAction
    implements Comparable<TimedAction> {
        final DiscardableAction<?> action;
        final Long execTime;
        final Integer count;

        private TimedAction(DiscardableAction<?> action, Long execTime, Integer count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return this.count.compareTo(that.count);
            }
            return result;
        }
    }
}

