/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationAverage {
    public static Observable<Integer> average(Observable<Integer> source) {
        return source.reduce(new Tuple2(0, 0), new Func2<Tuple2<Integer>, Integer, Tuple2<Integer>>(){

            @Override
            public Tuple2<Integer> call(Tuple2<Integer> accu, Integer next) {
                return new Tuple2<Integer>((Integer)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Integer>, Integer>(){

            @Override
            public Integer call(Tuple2<Integer> result) {
                return (Integer)((Tuple2)result).current / ((Tuple2)result).count;
            }
        });
    }

    public static Observable<Long> averageLongs(Observable<Long> source) {
        return source.reduce(new Tuple2(0L, 0), new Func2<Tuple2<Long>, Long, Tuple2<Long>>(){

            @Override
            public Tuple2<Long> call(Tuple2<Long> accu, Long next) {
                return new Tuple2<Long>((Long)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Long>, Long>(){

            @Override
            public Long call(Tuple2<Long> result) {
                return (Long)((Tuple2)result).current / (long)((Tuple2)result).count.intValue();
            }
        });
    }

    public static Observable<Float> averageFloats(Observable<Float> source) {
        return source.reduce(new Tuple2(Float.valueOf(0.0f), 0), new Func2<Tuple2<Float>, Float, Tuple2<Float>>(){

            @Override
            public Tuple2<Float> call(Tuple2<Float> accu, Float next) {
                return new Tuple2<Float>(Float.valueOf(((Float)((Tuple2)accu).current).floatValue() + next.floatValue()), ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Float>, Float>(){

            @Override
            public Float call(Tuple2<Float> result) {
                if (((Tuple2)result).count == 0) {
                    throw new ArithmeticException("divide by zero");
                }
                return Float.valueOf(((Float)((Tuple2)result).current).floatValue() / (float)((Tuple2)result).count.intValue());
            }
        });
    }

    public static Observable<Double> averageDoubles(Observable<Double> source) {
        return source.reduce(new Tuple2(0.0, 0), new Func2<Tuple2<Double>, Double, Tuple2<Double>>(){

            @Override
            public Tuple2<Double> call(Tuple2<Double> accu, Double next) {
                return new Tuple2<Double>((Double)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Double>, Double>(){

            @Override
            public Double call(Tuple2<Double> result) {
                if (((Tuple2)result).count == 0) {
                    throw new ArithmeticException("divide by zero");
                }
                return (Double)((Tuple2)result).current / (double)((Tuple2)result).count.intValue();
            }
        });
    }

    private static final class Tuple2<T> {
        private final T current;
        private final Integer count;

        private Tuple2(T v1, Integer v2) {
            this.current = v1;
            this.count = v2;
        }
    }
}

