/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public final class OperationOnErrorResumeNextViaObservable<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
        return new OnErrorResumeNextViaObservable<T>(originalSequence, resumeSequence);
    }

    private static class OnErrorResumeNextViaObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> resumeSequence;
        private final Observable<? extends T> originalSequence;

        public OnErrorResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
            this.resumeSequence = resumeSequence;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(subscription);
            subscription.wrap(this.originalSequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    if (subscriptionRef.get() == subscription) {
                        observer.onNext(value);
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription innerSubscription;
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription == subscription && !subscriptionRef.compareAndSet(currentSubscription, innerSubscription = new SafeObservableSubscription(OnErrorResumeNextViaObservable.this.resumeSequence.subscribe(observer)))) {
                        innerSubscription.unsubscribe();
                    }
                }

                @Override
                public void onCompleted() {
                    if (subscriptionRef.get() == subscription) {
                        observer.onCompleted();
                    }
                }
            }));
            return new Subscription(){

                @Override
                public void unsubscribe() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            };
        }
    }
}

