/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public class OperationToObservableFuture {
    public static <T> Observable.OnSubscribeFunc<T> toObservableFuture(Future<? extends T> that) {
        return new ToObservableFuture<T>(that);
    }

    public static <T> Observable.OnSubscribeFunc<T> toObservableFuture(Future<? extends T> that, long time, TimeUnit unit) {
        return new ToObservableFuture<T>(that, time, unit);
    }

    static class ToObservableFuture<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Future<? extends T> that;
        private final Long time;
        private final TimeUnit unit;

        public ToObservableFuture(Future<? extends T> that) {
            this.that = that;
            this.time = null;
            this.unit = null;
        }

        public ToObservableFuture(Future<? extends T> that, long time, TimeUnit unit) {
            this.that = that;
            this.time = time;
            this.unit = unit;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            try {
                T value;
                T t = value = this.time == null ? this.that.get() : this.that.get(this.time, this.unit);
                if (!this.that.isCancelled()) {
                    observer.onNext(value);
                }
                observer.onCompleted();
            }
            catch (Throwable e) {
                observer.onError(e);
            }
            return Subscriptions.empty();
        }
    }
}

