/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;

public class PublishSubject<T>
extends Subject<T, T> {
    private final ConcurrentHashMap<Subscription, Observer<? super T>> observers;

    public static <T> PublishSubject<T> create() {
        final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap<Subscription, Observer<? super T>>();
        Observable.OnSubscribeFunc onSubscribe = new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        observers.remove(subscription);
                    }
                });
                observers.put(subscription, observer);
                return subscription;
            }
        };
        return new PublishSubject<T>(onSubscribe, observers);
    }

    protected PublishSubject(Observable.OnSubscribeFunc<T> onSubscribe, ConcurrentHashMap<Subscription, Observer<? super T>> observers) {
        super(onSubscribe);
        this.observers = observers;
    }

    @Override
    public void onCompleted() {
        for (Observer<T> observer : this.snapshotOfValues()) {
            observer.onCompleted();
        }
        this.observers.clear();
    }

    @Override
    public void onError(Throwable e) {
        for (Observer<T> observer : this.snapshotOfValues()) {
            observer.onError(e);
        }
        this.observers.clear();
    }

    @Override
    public void onNext(T args) {
        for (Observer<T> observer : this.snapshotOfValues()) {
            observer.onNext(args);
        }
    }

    private Collection<Observer<? super T>> snapshotOfValues() {
        return new ArrayList<Observer<? super T>>(this.observers.values());
    }
}

