/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.DefaultPublishingPolicy;
import com.netflix.servo.monitor.PublishingPolicy;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.SmallTagMap;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class MonitorConfig {
    private final String name;
    private final TagList tags;
    private final PublishingPolicy policy;
    private final AtomicInteger cachedHashCode = new AtomicInteger(0);

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private MonitorConfig(Builder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"name cannot be null");
        this.tags = builder.tagsBuilder.isEmpty() ? BasicTagList.EMPTY : new BasicTagList(builder.tagsBuilder.result());
        this.policy = builder.policy;
    }

    public String getName() {
        return this.name;
    }

    public TagList getTags() {
        return this.tags;
    }

    public PublishingPolicy getPublishingPolicy() {
        return this.policy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MonitorConfig)) {
            return false;
        }
        MonitorConfig m = (MonitorConfig)obj;
        return this.name.equals(m.getName()) && this.tags.equals(m.getTags()) && this.policy.equals(m.getPublishingPolicy());
    }

    public int hashCode() {
        int hash = this.cachedHashCode.get();
        if (hash == 0) {
            hash = Objects.hashCode((Object[])new Object[]{this.name, this.tags, this.policy});
            this.cachedHashCode.set(hash);
        }
        return hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("tags", (Object)this.tags).add("policy", (Object)this.policy).toString();
    }

    private Builder copy() {
        return MonitorConfig.builder(this.name).withTags(this.tags).withPublishingPolicy(this.policy);
    }

    public MonitorConfig withAdditionalTag(Tag tag) {
        return this.copy().withTag(tag).build();
    }

    public MonitorConfig withAdditionalTags(TagList newTags) {
        return this.copy().withTags(newTags).build();
    }

    public static class Builder {
        private final String name;
        private SmallTagMap.Builder tagsBuilder = SmallTagMap.builder();
        private PublishingPolicy policy = DefaultPublishingPolicy.getInstance();

        public Builder(MonitorConfig config) {
            this(config.getName());
            this.withTags(config.getTags());
            this.withPublishingPolicy(config.getPublishingPolicy());
        }

        public Builder(String name) {
            this.name = name;
        }

        public Builder withTag(String key, String val) {
            this.tagsBuilder.add(Tags.newTag(key, val));
            return this;
        }

        public Builder withTag(Tag tag) {
            this.tagsBuilder.add(tag);
            return this;
        }

        public Builder withTags(TagList tagList) {
            if (tagList != null) {
                for (Tag t : tagList) {
                    this.tagsBuilder.add(t);
                }
            }
            return this;
        }

        public Builder withTags(Collection<Tag> tagCollection) {
            this.tagsBuilder.addAll(tagCollection);
            return this;
        }

        public Builder withTags(SmallTagMap.Builder tagsBuilder) {
            this.tagsBuilder = tagsBuilder;
            return this;
        }

        public Builder withPublishingPolicy(PublishingPolicy policy) {
            this.policy = policy;
            return this;
        }

        public MonitorConfig build() {
            return new MonitorConfig(this);
        }

        public String getName() {
            return this.name;
        }

        public List<Tag> getTags() {
            return ImmutableList.copyOf((Iterable)this.tagsBuilder.result());
        }

        public PublishingPolicy getPublishingPolicy() {
            return this.policy;
        }
    }
}

