/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.uri;

import com.networknt.schema.uri.URIFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public class URISchemeFetcher
implements URIFetcher {
    private final Map<String, URIFetcher> uriFetchers;

    public URISchemeFetcher(Map<String, URIFetcher> uriFetchers) {
        if (uriFetchers == null) {
            throw new IllegalArgumentException("URIFetcher map must not be null");
        }
        this.uriFetchers = uriFetchers;
    }

    public Map<String, URIFetcher> getURIFetchers() {
        return this.uriFetchers;
    }

    @Override
    public InputStream fetch(URI uri) throws IOException {
        URIFetcher uriFetcher = this.uriFetchers.get(uri.getScheme());
        if (uriFetcher == null) {
            throw new IllegalArgumentException(String.format("Unsupported URI scheme encountered: %s", uri.getScheme()));
        }
        return uriFetcher.fetch(uri);
    }
}

