/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteOnlyValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(WriteOnlyValidator.class);
    private final boolean writeOnly;

    public WriteOnlyValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.WRITE_ONLY, validationContext);
        this.writeOnly = validationContext.getConfig().isWriteOnly();
        logger.debug("Loaded WriteOnlyValidator for property {} as {}", (Object)parentSchema, (Object)"write mode");
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        WriteOnlyValidator.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (this.writeOnly) {
            errors.add(this.buildValidationMessage(at, new String[0]));
        }
        return errors;
    }
}

