/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Collector;
import com.networknt.schema.JsonSchema;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CollectorContext {
    private Map<String, Object> collectorMap = new HashMap<String, Object>();
    private Map<String, Object> collectorLoadMap = new HashMap<String, Object>();
    private final Deque<Scope> dynamicScopes = new LinkedList<Scope>();
    private final boolean disableUnevaluatedItems;
    private final boolean disableUnevaluatedProperties;

    public CollectorContext() {
        this(false, false);
    }

    public CollectorContext(boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties) {
        this.disableUnevaluatedItems = disableUnevaluatedItems;
        this.disableUnevaluatedProperties = disableUnevaluatedProperties;
        this.dynamicScopes.push(this.newTopScope());
    }

    public Scope enterDynamicScope() {
        return this.enterDynamicScope(null);
    }

    public Scope enterDynamicScope(JsonSchema containingSchema) {
        Scope parent = this.dynamicScopes.peek();
        this.dynamicScopes.push(this.newScope(null != containingSchema ? containingSchema : parent.getContainingSchema()));
        return parent;
    }

    public Scope exitDynamicScope() {
        return this.dynamicScopes.pop();
    }

    public Scope getDynamicScope() {
        return this.dynamicScopes.peek();
    }

    public JsonSchema getOutermostSchema() {
        JsonSchema context = this.getDynamicScope().getContainingSchema();
        if (null == context) {
            throw new IllegalStateException("Missing a root schema in the dynamic scope.");
        }
        JsonSchema lexicalRoot = context.findLexicalRoot();
        if (lexicalRoot.isDynamicAnchor()) {
            Iterator<Scope> it = this.dynamicScopes.descendingIterator();
            while (it.hasNext()) {
                Scope scope = it.next();
                JsonSchema containingSchema = scope.getContainingSchema();
                if (null == containingSchema || !containingSchema.isDynamicAnchor()) continue;
                return containingSchema;
            }
        }
        return context.findLexicalRoot();
    }

    public Collection<String> getEvaluatedItems() {
        return this.getDynamicScope().getEvaluatedItems();
    }

    public Collection<String> getEvaluatedProperties() {
        return this.getDynamicScope().getEvaluatedProperties();
    }

    public <E> void add(String name, Collector<E> collector) {
        this.collectorMap.put(name, collector);
    }

    public <E> void add(String name, Object object) {
        this.collectorMap.put(name, object);
    }

    public Object get(String name) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector && this.collectorLoadMap.get(name) != null) {
            return this.collectorLoadMap.get(name);
        }
        return this.collectorMap.get(name);
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.collectorMap);
        mergedMap.putAll(this.collectorLoadMap);
        return mergedMap;
    }

    public void combineWithCollector(String name, Object data) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector) {
            Collector collector = (Collector)object;
            collector.combine(data);
        }
    }

    void loadCollectors() {
        Set<Map.Entry<String, Object>> entrySet = this.collectorMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Collector)) continue;
            Collector collector = (Collector)entry.getValue();
            this.collectorLoadMap.put(entry.getKey(), collector.collect());
        }
    }

    private Scope newScope(JsonSchema containingSchema) {
        return new Scope(this.disableUnevaluatedItems, this.disableUnevaluatedProperties, containingSchema);
    }

    private Scope newTopScope() {
        return new Scope(true, this.disableUnevaluatedItems, this.disableUnevaluatedProperties, null);
    }

    public static class Scope {
        private final JsonSchema containingSchema;
        private final Collection<String> evaluatedItems;
        private final Collection<String> evaluatedProperties;
        private final boolean top;

        Scope(boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties, JsonSchema containingSchema) {
            this(false, disableUnevaluatedItems, disableUnevaluatedProperties, containingSchema);
        }

        Scope(boolean top, boolean disableUnevaluatedItems, boolean disableUnevaluatedProperties, JsonSchema containingSchema) {
            this.top = top;
            this.containingSchema = containingSchema;
            this.evaluatedItems = Scope.newCollection(disableUnevaluatedItems);
            this.evaluatedProperties = Scope.newCollection(disableUnevaluatedProperties);
        }

        private static Collection<String> newCollection(boolean disabled) {
            return !disabled ? new ArrayList() : new AbstractCollection<String>(){

                @Override
                public boolean add(String e) {
                    return false;
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.emptyIterator();
                }

                @Override
                public boolean remove(Object o) {
                    return false;
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }

        public boolean isTop() {
            return this.top;
        }

        public JsonSchema getContainingSchema() {
            return this.containingSchema;
        }

        public Collection<String> getEvaluatedItems() {
            return this.evaluatedItems;
        }

        public Collection<String> getEvaluatedProperties() {
            return this.evaluatedProperties;
        }

        public Scope mergeWith(Scope scope) {
            this.getEvaluatedItems().addAll(scope.getEvaluatedItems());
            this.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
            return this;
        }

        public String toString() {
            return "{ " + "\"evaluatedItems\": " + this.evaluatedItems + ", " + "\"evaluatedProperties\": " + this.evaluatedProperties + " }";
        }
    }
}

