/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecursiveRefValidator.class);

    public RecursiveRefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.RECURSIVE_REF, validationContext);
        String refValue = schemaNode.asText();
        if (!"#".equals(refValue)) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.RECURSIVE_REF.getValue(), CustomErrorMessageType.of("internal.invalidRecursiveRef"), new MessageFormat("{0}: The value of a $recursiveRef must be '#' but is '{1}'"), schemaPath, schemaPath, refValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, at);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                schema.getValidationContext().setConfig(this.getParentSchema().getValidationContext().getConfig());
                errors = schema.validate(executionContext, node, rootNode, at);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, at);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                schema.getValidationContext().setConfig(this.getParentSchema().getValidationContext().getConfig());
                errors = schema.walk(executionContext, node, rootNode, at, shouldValidateSchema);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }
}

