/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.ValidationMessage;
import com.networknt.schema.i18n.MessageSource;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

public class MessageSourceValidationMessage {
    public static Builder builder(MessageSource messageSource, Map<String, String> errorMessage, BiConsumer<ValidationMessage, Boolean> observer) {
        return new Builder(messageSource, errorMessage, observer);
    }

    public static abstract class BuilderSupport<S>
    extends ValidationMessage.BuilderSupport<S> {
        private final BiConsumer<ValidationMessage, Boolean> observer;
        private final MessageSource messageSource;
        private final Map<String, String> errorMessage;
        private boolean failFast;
        private Locale locale;

        public BuilderSupport(MessageSource messageSource, Map<String, String> errorMessage, BiConsumer<ValidationMessage, Boolean> observer) {
            this.messageSource = messageSource;
            this.observer = observer;
            this.errorMessage = errorMessage;
        }

        @Override
        public ValidationMessage build() {
            String messagePattern = null;
            if (this.errorMessage != null) {
                String specificMessagePattern;
                messagePattern = this.errorMessage.get("");
                if (this.property != null && (specificMessagePattern = this.errorMessage.get(this.property)) != null) {
                    messagePattern = specificMessagePattern;
                }
                this.message = messagePattern;
            }
            if (this.message == null && this.messageSupplier == null && this.messageFormatter == null) {
                this.messageFormatter = args -> this.messageSource.getMessage(this.messageKey, this.locale == null ? Locale.ROOT : this.locale, args);
            }
            ValidationMessage validationMessage = super.build();
            if (this.observer != null) {
                this.observer.accept(validationMessage, this.failFast);
            }
            return validationMessage;
        }

        public S locale(Locale locale) {
            this.locale = locale;
            return this.self();
        }

        public S failFast(boolean failFast) {
            this.failFast = failFast;
            return this.self();
        }
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        public Builder(MessageSource messageSource, Map<String, String> errorMessage, BiConsumer<ValidationMessage, Boolean> observer) {
            super(messageSource, errorMessage, observer);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

