/*
 * Copyright (c) 2020 Network New Technologies Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.networknt.schema;

import java.util.function.Supplier;

/**
 * Use this object instead a Schema for references.
 */
public class SchemaRef {

    private final Supplier<Schema> schemaSupplier;

    public SchemaRef(Supplier<Schema> schema) {
        this.schemaSupplier = schema;
    }

    public Schema getSchema() {
        return this.schemaSupplier.get();
    }
}
