/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.bridge.Agent;
import com.newrelic.agent.bridge.NoOpMetricAggregator;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.api.agent.Config;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import java.util.logging.Level;

public class AgentImpl
implements Agent {
    private final Logger logger;

    public AgentImpl(Logger logger) {
        this.logger = logger;
    }

    public TracedMethod getTracedMethod() {
        this.getLogger().log(Level.FINER, "Unexpected call to Agent.getTracedMethod()", new Object[0]);
        return NoOpTracedMethod.INSTANCE;
    }

    public com.newrelic.agent.bridge.Transaction getTransaction() {
        Transaction innerTx = Transaction.getTransaction();
        if (innerTx != null) {
            return new TransactionApiImpl();
        }
        return NoOpTransaction.INSTANCE;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getConfig() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig();
    }

    public MetricAggregator getMetricAggregator() {
        try {
            Transaction tx = Transaction.getTransaction(false);
            if (tx != null && tx.isInProgress()) {
                return tx.getMetricAggregator();
            }
            return ServiceFactory.getStatsService().getMetricAggregator();
        }
        catch (Throwable t) {
            com.newrelic.agent.Agent.LOG.log(Level.FINE, "getMetricAggregator() call failed : {0}", new Object[]{t.getMessage()});
            com.newrelic.agent.Agent.LOG.log(Level.FINEST, t, "getMetricAggregator() call failed", new Object[0]);
            return NoOpMetricAggregator.INSTANCE;
        }
    }
}

