/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.tracers.CrossProcessNameFormat;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class CrossProcessTransactionStateImpl
implements CrossProcessTransactionState {
    public static final String NEWRELIC_ID_HEADER = "X-NewRelic-ID";
    public static final String NEWRELIC_ID_MESSAGE_HEADER = "NewRelicID";
    public static final String NEWRELIC_TRANSACTION_HEADER = "X-NewRelic-Transaction";
    public static final String NEWRELIC_TRANSACTION_MESSAGE_HEADER = "NewRelicTransaction";
    public static final String NEWRELIC_APP_DATA_HEADER = "X-NewRelic-App-Data";
    public static final String NEWRELIC_APP_DATA_MESSAGE_HEADER = "NewRelicAppData";
    private static final String CONTENT_LENGTH_REQUEST_HEADER = "Content-Length";
    private static final String NEWRELIC_ID_HEADER_SEPARATOR = "#";
    private static final boolean OPTIMISTIC_TRACING = false;
    private static final int ALTERNATE_PATH_HASH_MAX_COUNT = 10;
    private final ITransaction tx;
    private final Object lock;
    private volatile boolean processInboundRequestDone = false;
    private volatile boolean processOutboundResponseDone = false;
    private volatile String clientCrossProcessId;
    private volatile String tripId;
    private volatile String guid;
    private volatile String referrerGuid;
    private volatile Integer referringPathHash;
    private final Set<String> alternatePathHashes;

    private CrossProcessTransactionStateImpl(ITransaction tx) {
        this.tx = tx;
        this.lock = tx instanceof Transaction ? ((Transaction)tx).getLock() : new Object();
        MapMaker factory = new MapMaker().initialCapacity(8).concurrencyLevel(4);
        this.alternatePathHashes = Sets.newSetFromMap(new LazyMapImpl(factory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponseHeaders() {
        if (this.tx.isIgnore()) {
            return;
        }
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (dispatcher == null) {
            return;
        }
        Request request = dispatcher.getRequest();
        Response response = dispatcher.getResponse();
        Object object = this.lock;
        synchronized (object) {
            this.processInboundRequestHeaders((InboundHeaders)request);
            long contentLength = this.getRequestContentLength(request);
            this.processOutboundResponseHeaders((OutboundHeaders)response, contentLength);
        }
    }

    private long getRequestContentLength(Request request) {
        String contentLengthString;
        long contentLength = -1L;
        String string = contentLengthString = request == null ? null : request.getHeader(CONTENT_LENGTH_REQUEST_HEADER);
        if (contentLengthString != null) {
            try {
                contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing {0} response header: {1}: {2}", CONTENT_LENGTH_REQUEST_HEADER, contentLengthString, e);
                Agent.LOG.finer(msg);
            }
        }
        return contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            String crossProcessId;
            if (null == outboundHeaders || null == this.tx.getDispatcher() || this.tx.isIgnore()) {
                return;
            }
            if (!this.processInboundRequestDone) {
                this.processInboundRequestHeaders((InboundHeaders)this.tx.getDispatcher().getRequest());
            }
            if ((crossProcessId = this.tx.getCrossProcessConfig().getEncodedCrossProcessId()) != null) {
                String idKey = CrossProcessTransactionStateImpl.getIdKey(outboundHeaders);
                if (Agent.LOG.isFinerEnabled()) {
                    Agent.LOG.log(Level.FINER, "Sending {0} header: {1}", new Object[]{idKey, crossProcessId});
                }
                outboundHeaders.setHeader(idKey, crossProcessId);
                String json = this.getTransactionHeaderValue();
                if (json != null) {
                    outboundHeaders.setHeader(CrossProcessTransactionStateImpl.getTransactionKey(outboundHeaders), json);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInboundRequestHeaders(InboundHeaders inboundHeaders) {
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (inboundHeaders == null || this.processInboundRequestDone) {
                return;
            }
            String idKey = CrossProcessTransactionStateImpl.getIdKey(inboundHeaders);
            this.clientCrossProcessId = this.getTrustedClientCrossProcessId(inboundHeaders.getHeader(idKey));
            if (this.clientCrossProcessId == null) {
                return;
            }
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest("Client cross process id is " + this.clientCrossProcessId);
            }
            if (this.tx.isIgnore()) {
                return;
            }
            String txKey = CrossProcessTransactionStateImpl.getTransactionKey(inboundHeaders);
            String encodedTransactionHeader = inboundHeaders.getHeader(txKey);
            this.processTransactionHeader(encodedTransactionHeader);
            this.processInboundRequestDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOutboundResponseHeaders(OutboundHeaders outboundHeaders, long contentLength) {
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.tx.isIgnore() || outboundHeaders == null || this.clientCrossProcessId == null || this.processOutboundResponseDone) {
                return;
            }
            this.tx.freezeTransactionName();
            long durationInNanos = this.tx.getRunningDurationInNanos();
            this.recordClientApplicationMetric(durationInNanos);
            String guid = null;
            if (this.referrerGuid != null) {
                guid = this.getOrCreateGuid();
            }
            this.writeCrossProcessAppDataResponseHeader(durationInNanos, contentLength, guid, outboundHeaders);
            this.processOutboundResponseDone = true;
        }
    }

    public void processInboundResponseHeaders(InboundHeaders inboundHeaders, TracedMethod tracer, String host, String uri, boolean addRollupMetrics) {
        String encodingKey;
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return;
        }
        if (inboundHeaders == null || tracer == null) {
            return;
        }
        String appDataKey = CrossProcessTransactionStateImpl.getAppDataKey(inboundHeaders);
        String encodedAppData = inboundHeaders.getHeader(appDataKey);
        CrossProcessNameFormat crossProcessFormat = CrossProcessNameFormat.create(host, uri, encodedAppData, encodingKey = this.tx.getCrossProcessConfig().getEncodingKey());
        if (crossProcessFormat != null) {
            if (tracer instanceof DefaultTracer) {
                DefaultTracer dt = (DefaultTracer)tracer;
                String transactionId = crossProcessFormat.getTransactionId();
                if (transactionId != null && transactionId.length() > 0) {
                    dt.setParameter("transaction_guid", transactionId);
                }
                dt.setMetricNameFormat(crossProcessFormat);
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Received {0} cross process response header for external call: {1}", new Object[]{NEWRELIC_APP_DATA_HEADER, crossProcessFormat.toString()});
                }
            }
            if (addRollupMetrics && !host.equals("Unknown")) {
                tracer.addRollupMetricName(new String[]{crossProcessFormat.getHostCrossProcessIdRollupMetricName()});
            }
        }
        if (addRollupMetrics) {
            tracer.addRollupMetricName(new String[]{"External", host, "all"});
            tracer.addRollupMetricName(new String[]{"External/all"});
            if (Transaction.getTransaction().isWebTransaction()) {
                tracer.addRollupMetricName(new String[]{"External/allWeb"});
            } else {
                tracer.addRollupMetricName(new String[]{"External/allOther"});
            }
        }
    }

    private static String getIdKey(Object headers) {
        return CrossProcessTransactionStateImpl.getTypedHeaderKey(headers, NEWRELIC_ID_HEADER, NEWRELIC_ID_MESSAGE_HEADER);
    }

    private static String getTransactionKey(Object headers) {
        return CrossProcessTransactionStateImpl.getTypedHeaderKey(headers, NEWRELIC_TRANSACTION_HEADER, NEWRELIC_TRANSACTION_MESSAGE_HEADER);
    }

    private static String getAppDataKey(Object headers) {
        return CrossProcessTransactionStateImpl.getTypedHeaderKey(headers, NEWRELIC_APP_DATA_HEADER, NEWRELIC_APP_DATA_MESSAGE_HEADER);
    }

    private static String getTypedHeaderKey(Object headers, String httpHeader, String messageHeader) {
        HeaderType type = null;
        if (headers instanceof InboundHeaders) {
            type = ((InboundHeaders)headers).getHeaderType();
        } else if (headers instanceof OutboundHeaders) {
            type = ((OutboundHeaders)headers).getHeaderType();
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case MESSAGE: {
                return messageHeader;
            }
        }
        return httpHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTransactionHeaderValue() {
        Object object = this.lock;
        synchronized (object) {
            String guid = this.getOrCreateGuid();
            if (guid == null) {
                return null;
            }
            String json = this.getTransactionHeaderJson(guid, this.getForceTransactionTrace(), this.getOrCreateTripId(), this.generatePathHash());
            String encoded = this.getEncodedJson(json);
            if (Agent.LOG.isFinerEnabled()) {
                String msg = MessageFormat.format("Sending {0} header: {1} obfuscated: {2}", NEWRELIC_TRANSACTION_HEADER, json, encoded);
                Agent.LOG.finer(msg);
            }
            return encoded;
        }
    }

    private String getTransactionHeaderJson(String guid, boolean forceTransactionTrace, String trip, int pathHash) {
        List<Serializable> args = Arrays.asList(guid, forceTransactionTrace, trip, ServiceUtils.intToHexString(pathHash));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString();
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error getting JSON: {0}", e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrCreateGuid() {
        Object object = this.lock;
        synchronized (object) {
            if (this.guid == null) {
                this.guid = this.tx.getBeaconTransactionState().getGuid();
                if (this.guid == null) {
                    this.guid = this.createGuid();
                }
            }
            return this.guid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrCreateTripId() {
        Object object = this.lock;
        synchronized (object) {
            if (this.guid == null) {
                this.guid = this.tx.getBeaconTransactionState().getGuid();
                if (this.guid == null) {
                    this.guid = this.createGuid();
                }
            }
            if (this.tripId == null) {
                this.tripId = this.guid;
            }
            return this.tripId;
        }
    }

    private String createGuid() {
        return ServiceFactory.getTransactionTraceService().generateTransactionGuid();
    }

    private String getTrustedClientCrossProcessId(String clientCrossProcessId) {
        if (clientCrossProcessId == null || clientCrossProcessId.length() == 0) {
            return null;
        }
        CrossProcessConfig crossProcessConfig = this.tx.getCrossProcessConfig();
        if (crossProcessConfig.getEncodingKey() == null || crossProcessConfig.getCrossProcessId() == null) {
            return null;
        }
        String decoded = this.getDecodedClientCrossProcessId(clientCrossProcessId);
        if (!this.isClientCrossProcessIdTrusted(decoded)) {
            return null;
        }
        return decoded;
    }

    private void processTransactionHeader(String encodedJson) {
        if (encodedJson == null || encodedJson.length() == 0) {
            return;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        String json = null;
        try {
            json = Obfuscator.deobfuscateNameUsingKey(encodedJson, encodingKey);
        }
        catch (UnsupportedEncodingException ex) {
            String msg = MessageFormat.format("Error decoding {0} header {1}: {2}", NEWRELIC_TRANSACTION_HEADER, encodedJson, ex);
            Agent.LOG.error(msg);
        }
        if (json != null) {
            this.parseTransactionHeader(json);
        }
    }

    private void parseTransactionHeader(String header) {
        block4: {
            try {
                JSONParser parser = new JSONParser();
                JSONArray arr = (JSONArray)parser.parse(header);
                this.referrerGuid = (String)arr.get(0);
                if (arr.size() >= 3) {
                    this.tripId = (String)arr.get(2);
                }
                if (arr.size() >= 4) {
                    this.referringPathHash = ServiceUtils.hexStringToInt((String)arr.get(3));
                }
            }
            catch (Exception ex) {
                if (!Agent.LOG.isFinerEnabled()) break block4;
                String msg = MessageFormat.format("Unable to parse {0} header {1}: {2}", NEWRELIC_TRANSACTION_HEADER, header, ex);
                Agent.LOG.finer(msg);
            }
        }
    }

    private boolean isClientCrossProcessIdTrusted(String clientCrossProcessId) {
        String accountId = this.getAccountId(clientCrossProcessId);
        if (accountId != null) {
            if (this.tx.getCrossProcessConfig().isTrustedAccountId(accountId)) {
                return true;
            }
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Account id {0} in client cross process id {1} is not trusted", accountId, clientCrossProcessId);
                Agent.LOG.log(Level.FINEST, msg);
            }
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Account id not found in client cross process id {0}", clientCrossProcessId);
            Agent.LOG.log(Level.FINER, msg);
        }
        return false;
    }

    private String getAccountId(String clientCrossProcessId) {
        String accountId = null;
        int index = clientCrossProcessId.indexOf(NEWRELIC_ID_HEADER_SEPARATOR);
        if (index > 0) {
            accountId = clientCrossProcessId.substring(0, index);
        }
        return accountId;
    }

    private String getDecodedClientCrossProcessId(String clientCrossProcessId) {
        if (clientCrossProcessId.length() == 0) {
            return clientCrossProcessId;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.deobfuscateNameUsingKey(clientCrossProcessId, encodingKey);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("Error decoding cross process id {0}: {1}", clientCrossProcessId, ex);
            Agent.LOG.error(msg);
            return null;
        }
    }

    private void writeCrossProcessAppDataResponseHeader(long durationInNanos, long contentLength, String guid, OutboundHeaders responseHeaders) {
        String json = this.getCrossProcessAppDataJson(durationInNanos, contentLength, guid);
        String encodedJson = this.getEncodedJson(json);
        if (encodedJson == null) {
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Setting {0} response header to: {1}", NEWRELIC_APP_DATA_HEADER, json);
            Agent.LOG.log(Level.FINER, msg);
        }
        responseHeaders.setHeader(CrossProcessTransactionStateImpl.getTypedHeaderKey(responseHeaders, NEWRELIC_APP_DATA_HEADER, NEWRELIC_APP_DATA_MESSAGE_HEADER), encodedJson);
    }

    private String getCrossProcessAppDataJson(long durationInNanos, long contentLength, String guid) {
        String crossProcessId = this.tx.getCrossProcessConfig().getCrossProcessId();
        String transactionName = this.tx.getPriorityTransactionName().getName();
        Float queueTimeInSeconds = Float.valueOf((float)this.tx.getExternalTime() / 1000.0f);
        Float durationInSeconds = Float.valueOf((float)durationInNanos / 1.0E9f);
        List<Serializable> args = guid == null ? Arrays.asList(crossProcessId, transactionName, queueTimeInSeconds, durationInSeconds, contentLength) : Arrays.asList(crossProcessId, transactionName, queueTimeInSeconds, durationInSeconds, contentLength, guid);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString();
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error getting JSON: {0}", e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    private String getEncodedJson(String json) {
        if (json == null) {
            return null;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(json, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            String msg = MessageFormat.format("Error encoding {0} response header {1} using key {2}: {3}", NEWRELIC_APP_DATA_HEADER, json, encodingKey, e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    public void recordClientApplicationMetric(long durationInNanos) {
        if (this.clientCrossProcessId == null || this.clientCrossProcessId.length() == 0) {
            return;
        }
        String metricName = MessageFormat.format("ClientApplication/{0}/all", this.clientCrossProcessId);
        this.tx.getTransactionActivity().getTransactionStats().getUnscopedStats().getResponseTimeStats(metricName).recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    private boolean getForceTransactionTrace() {
        return false;
    }

    public String getClientCrossProcessId() {
        return this.clientCrossProcessId;
    }

    public String getReferrerGuid() {
        return this.referrerGuid;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTripId() {
        return this.tripId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generatePathHash() {
        Object object = this.lock;
        synchronized (object) {
            int pathHash = ServiceUtils.calculatePathHash(this.tx.getApplicationName(), this.tx.getPriorityTransactionName().getName(), this.referringPathHash);
            if (this.alternatePathHashes.size() < 10) {
                this.alternatePathHashes.add(ServiceUtils.intToHexString(pathHash));
            }
            return pathHash;
        }
    }

    public Integer getReferringPathHash() {
        return this.referringPathHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlternatePathHashes() {
        Object object = this.lock;
        synchronized (object) {
            TreeSet<String> hashes = new TreeSet<String>(this.alternatePathHashes);
            hashes.remove(ServiceUtils.intToHexString(this.generatePathHash()));
            StringBuilder result = new StringBuilder();
            for (String alternatePathHash : hashes) {
                result.append(alternatePathHash);
                result.append(",");
            }
            return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
        }
    }

    public void setClientCrossProcessId(String clientCrossProcessId) {
        this.clientCrossProcessId = clientCrossProcessId;
    }

    public static CrossProcessTransactionStateImpl create(ITransaction tx) {
        return tx == null ? null : new CrossProcessTransactionStateImpl(tx);
    }
}

