/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.CrossProcessTransactionStateImpl;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TracerList;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.application.AbstractApplicationNamingPolicy;
import com.newrelic.agent.application.HigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.application.PriorityApplicationName;
import com.newrelic.agent.application.SameOrHigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.beacon.BeaconTransactionState;
import com.newrelic.agent.beacon.BeaconTransactionStateImpl;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.CrossProcessState;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.CachingDatabaseStatementParser;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.RemovalCause;
import com.newrelic.agent.deps.com.google.common.cache.RemovalListener;
import com.newrelic.agent.deps.com.google.common.cache.RemovalNotification;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.WebRequestDispatcher;
import com.newrelic.agent.messaging.MessagingUtil;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.servlet.ServletUtils;
import com.newrelic.agent.sql.SqlTracerListener;
import com.newrelic.agent.stats.AbstractMetricAggregator;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.transaction.ConnectionCache;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionCache;
import com.newrelic.agent.transaction.TransactionCounts;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionTimer;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.ApplicationNamePriority;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
implements ITransaction {
    static final ClassMethodSignature REQUEST_INITIALIZED_CLASS_SIGNATURE = new ClassMethodSignature("javax.servlet.ServletRequestListener", "requestInitialized", "(Ljavax/servlet/ServletRequestEvent;)V");
    static final int REQUEST_INITIALIZED_CLASS_SIGNATURE_ID = ClassMethodSignatures.get().add(REQUEST_INITIALIZED_CLASS_SIGNATURE);
    private static final String THREAD_ASSERTION_FAILURE = "Thread assertion failed!";
    private static final ThreadLocal<Transaction> transactionHolder = new ThreadLocal<Transaction>(){

        @Override
        public void remove() {
            ServiceFactory.getTransactionService().removeTransaction();
            super.remove();
        }

        @Override
        public void set(Transaction value) {
            super.set(value);
            ServiceFactory.getTransactionService().addTransaction(value);
        }
    };
    private static final PendingActivities pendingActivities = new PendingActivities();
    private final long wallClockStartTimeMs;
    private final IAgent agent;
    private final boolean ttEnabled;
    private final TransactionCounts counts;
    private final boolean autoAppNamingEnabled;
    private final boolean transactionNamingEnabled;
    private final AtomicReference<Throwable> throwable = new AtomicReference();
    private final Object lock = new Object();
    private final long startGCTimeInMillis;
    private final Map<Object, TransactionActivity> runningChildren;
    private final Map<Object, TransactionActivity> finishedChildren;
    private final Map<String, Object> internalParameters;
    private final Map<String, Map<String, String>> prefixedAgentAttributes;
    private final Map<String, Object> agentAttributes;
    private final Map<String, Object> intrinsicAttributes;
    private final Map<String, Object> userAttributes;
    private final Map<String, String> errorAttributes;
    private final Map<Object, Tracer> contextToTracer;
    private final Map<Object, Tracer> timedOutKeys;
    private volatile boolean ignore;
    private volatile Dispatcher dispatcher;
    private volatile Tracer rootTracer;
    private volatile TransactionTimer transactionTime;
    private volatile TransactionState transactionState = new TransactionStateImpl();
    private volatile TransactionActivity initialActivity = null;
    private volatile ConnectionCache connectionCache = null;
    private volatile PriorityTransactionName priorityTransactionName = PriorityTransactionName.NONE;
    private volatile PriorityApplicationName priorityApplicationName = PriorityApplicationName.NONE;
    private CrossProcessTransactionState crossProcessTransactionState;
    private DatabaseStatementParser databaseStatementParser;
    private String normalizedUri;
    private AgentConfig agentConfig;
    private SqlTracerListener sqlTracerListener;
    private BeaconTransactionState beaconTransactionState;
    private final LegacyState legacyState = new LegacyState();
    private final MetricAggregator metricAggregator = new AbstractMetricAggregator(){

        protected void doRecordResponseTimeMetric(String name, long totalTime, long exclusiveTime, TimeUnit timeUnit) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getResponseTimeStats(name).recordResponseTime(totalTime, exclusiveTime, timeUnit);
        }

        protected void doRecordMetric(String name, float value) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).recordDataPoint(value);
        }

        protected void doIncrementCounter(String name, int count) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).incrementCallCount(count);
        }
    };
    private static final WebResponse DEFAULT_RESPONSE = new WebResponse(){

        public void setStatusMessage(String message) {
        }

        public void setStatus(int statusCode) {
        }

        public int getStatus() {
            return 0;
        }

        public String getStatusMessage() {
            return null;
        }

        public void freezeStatus() {
        }
    };
    private static final Request DUMMY_REQUEST = new Request(){

        public String[] getParameterValues(String name) {
            return null;
        }

        public Enumeration<?> getParameterNames() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public String getRequestURI() {
            return "/";
        }

        public String getRemoteUser() {
            return null;
        }

        public String getHeader(String name) {
            return null;
        }

        public String getCookieValue(String name) {
            return null;
        }

        public HeaderType getHeaderType() {
            return HeaderType.HTTP;
        }
    };
    private static final Response DUMMY_RESPONSE = new Response(){

        public int getStatus() throws Exception {
            return 0;
        }

        public String getStatusMessage() throws Exception {
            return null;
        }

        public void setHeader(String name, String value) {
        }

        public String getContentType() {
            return null;
        }

        public HeaderType getHeaderType() {
            return HeaderType.HTTP;
        }
    };
    private static final int REQUEST_TRACER_FLAGS = 14;
    private final Object requestStateChangeLock = new Object();

    public static void cleanUpAsyncTransForTesting() {
        pendingActivities.cleanUp();
    }

    private Transaction() {
        Agent.LOG.log(Level.FINE, "create Transaction {0}", new Object[]{this});
        if (Agent.LOG.isFinestEnabled() && Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINEST, "backtrace: {0}", new Object[]{Arrays.toString(Thread.currentThread().getStackTrace())});
        }
        AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.agent = ServiceFactory.getAgent();
        this.autoAppNamingEnabled = defaultConfig.isAutoAppNamingEnabled();
        this.transactionNamingEnabled = this.initializeTransactionNamingEnabled(defaultConfig);
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.ttEnabled = ttService.isEnabled();
        this.wallClockStartTimeMs = System.currentTimeMillis();
        this.counts = new TransactionCounts(defaultConfig);
        MapMaker factory = new MapMaker().initialCapacity(8).concurrencyLevel(4);
        this.internalParameters = new LazyMapImpl<String, Object>(factory);
        this.prefixedAgentAttributes = new LazyMapImpl<String, Map<String, String>>(factory);
        this.agentAttributes = new LazyMapImpl<String, Object>(factory);
        this.intrinsicAttributes = new LazyMapImpl<String, Object>(factory);
        this.userAttributes = new LazyMapImpl<String, Object>(factory);
        this.errorAttributes = new LazyMapImpl<String, String>(factory);
        this.contextToTracer = new LazyMapImpl<Object, Tracer>(new MapMaker().initialCapacity(25).concurrencyLevel(16));
        this.timedOutKeys = new LazyMapImpl<Object, Tracer>(factory);
        this.runningChildren = new LazyMapImpl<Object, TransactionActivity>(factory);
        this.finishedChildren = new LazyMapImpl<Object, TransactionActivity>(factory);
        this.startGCTimeInMillis = ServiceFactory.getTransactionTraceService().isEnabled() ? (defaultConfig.getTransactionTracerConfig().isGCTimeEnabled() ? Transaction.getGCTime() : -1L) : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postConstruct() {
        TransactionActivity txa = TransactionActivity.create(this);
        txa.setContext(txa);
        this.initialActivity = txa;
        this.legacyState.boundThreads.add(Thread.currentThread().getId());
        Object object = this.lock;
        synchronized (object) {
            this.runningChildren.put(txa.getContext(), txa);
        }
    }

    private static long getGCTime() {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    private boolean initializeTransactionNamingEnabled(AgentConfig config) {
        if (!config.isAutoTransactionNamingEnabled()) {
            return false;
        }
        IRPMService rpmService = this.getRPMService();
        if (rpmService == null) {
            return true;
        }
        String transactionNamingScheme = this.getRPMService().getTransactionNamingScheme();
        return "framework" != transactionNamingScheme;
    }

    public MetricAggregator getMetricAggregator() {
        return this.metricAggregator;
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentConfig getAgentConfig() {
        Object object = this.lock;
        synchronized (object) {
            if (this.agentConfig == null) {
                String appName = this.getApplicationName();
                this.agentConfig = ServiceFactory.getConfigService().getAgentConfig(appName);
            }
            return this.agentConfig;
        }
    }

    public long getWallClockStartTimeMs() {
        return this.wallClockStartTimeMs;
    }

    public Map<String, Object> getInternalParameters() {
        return this.internalParameters;
    }

    @Override
    public Map<String, Map<String, String>> getPrefixedAgentAttributes() {
        return this.prefixedAgentAttributes;
    }

    @Override
    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    @Override
    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    @Override
    public Map<String, Object> getIntrinsicAttributes() {
        return this.intrinsicAttributes;
    }

    public Map<String, String> getErrorAttributes() {
        return this.errorAttributes;
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        if (this.dispatcher == null) {
            return this.getAgentConfig().getTransactionTracerConfig();
        }
        return this.dispatcher.getTransactionTracerConfig();
    }

    @Override
    public CrossProcessConfig getCrossProcessConfig() {
        return this.getAgentConfig().getCrossProcessConfig();
    }

    public boolean setTransactionName(com.newrelic.api.agent.TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.setTransactionName(TransactionNamePriority.convert((com.newrelic.api.agent.TransactionNamePriority)namePriority), override, category, parts);
    }

    public boolean setTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.getRootTransaction().doSetTransactionName(namePriority, override, category, parts);
    }

    @Deprecated
    public boolean isTransactionNameSet() {
        return this.getRootTransaction().getPriorityTransactionName().getPriority().isGreaterThan(TransactionNamePriority.NONE);
    }

    private boolean doSetTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        if (namePriority.isLessThan(TransactionNamePriority.CUSTOM_HIGH) && !this.isTransactionNamingEnabled()) {
            return false;
        }
        String name = Strings.join('/', parts);
        if (this.dispatcher == null) {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest(MessageFormat.format("Unable to set the transaction name to \"{0}\" - no transaction", name));
            }
            return false;
        }
        TransactionNamingPolicy policy = override ? TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy() : TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        return policy.setTransactionName(this, name, category, namePriority);
    }

    @Override
    public PriorityTransactionName getPriorityTransactionName() {
        return this.priorityTransactionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeTransactionName() {
        Object object = this.lock;
        synchronized (object) {
            if (this.priorityTransactionName.isFrozen()) {
                return;
            }
            this.dispatcher.setTransactionName();
            this.renameTransaction();
            this.priorityTransactionName = this.priorityTransactionName.freeze();
        }
    }

    private void renameTransaction() {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        String appName = this.getApplicationName();
        Normalizer txNormalizer = ServiceFactory.getNormalizationService().getTransactionNormalizer(appName);
        String txName = txNormalizer.normalize(this.priorityTransactionName.getName());
        if (txName == null) {
            this.setIgnore(true);
            return;
        }
        if (!txName.equals(this.priorityTransactionName.getName())) {
            this.setPriorityTransactionNameLocked(PriorityTransactionName.create(txName, this.isWebTransaction() ? "Web" : "Other", TransactionNamePriority.REQUEST_URI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conditionalSetPriorityTransactionName(TransactionNamingPolicy policy, String name, String category, TransactionNamePriority priority) {
        Object object = this.lock;
        synchronized (object) {
            if (policy.canSetTransactionName(this, priority)) {
                Agent.LOG.log(Level.FINER, "Setting transaction name to \"{0}\"", new Object[]{name});
                return this.setPriorityTransactionNameLocked(policy.getPriorityTransactionName(this, name, category, priority));
            }
            Agent.LOG.log(Level.FINER, "Unable to set the transaction name to  \"{0}\"", new Object[]{name});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPriorityTransactionName(PriorityTransactionName ptn) {
        Object object = this.lock;
        synchronized (object) {
            return this.setPriorityTransactionNameLocked(ptn);
        }
    }

    private boolean setPriorityTransactionNameLocked(PriorityTransactionName ptn) {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        if (ptn == null) {
            return false;
        }
        this.priorityTransactionName = ptn;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlTracerListener getSqlTracerListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.sqlTracerListener == null) {
                String appName = this.getApplicationName();
                this.sqlTracerListener = ServiceFactory.getSqlTraceService().getSqlTracerListener(appName);
            }
            return this.sqlTracerListener;
        }
    }

    public TransactionCache getTransactionCache() {
        return this.getTransactionActivity().getTransactionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionCache getConnectionCache() {
        if (this.connectionCache == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.connectionCache == null) {
                    this.connectionCache = new ConnectionCache();
                }
            }
        }
        return this.connectionCache;
    }

    @Override
    public boolean isStarted() {
        return this.getDispatcher() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.isStarted() && this.runningChildren.isEmpty() && this.contextToTracer.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInProgress() {
        Object object = this.lock;
        synchronized (object) {
            return this.isStarted() && (!this.runningChildren.isEmpty() || !this.contextToTracer.isEmpty());
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public long getExternalTime() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return ((WebRequestDispatcher)this.dispatcher).getQueueTime();
        }
        return 0L;
    }

    @Override
    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public List<Tracer> getAllTracers() {
        this.transactionState.mergeAsyncTracers();
        return this.getTracers();
    }

    public List<Tracer> getTracers() {
        return new TracerList(this.getRootTracer(), this.getFinishedChildren());
    }

    @Override
    public TransactionActivity getTransactionActivity() {
        if (this.legacyState.boundThreads.size() == 0) {
            return this.initialActivity;
        }
        TransactionActivity result = TransactionActivity.get();
        if (result == null) {
            throw new IllegalStateException("TransactionActivity is gone");
        }
        return result;
    }

    void activityStarted(TransactionActivity activity) {
        Agent.LOG.log(Level.FINER, "activity {0} starting", new Object[]{activity});
        this.startTransactionIfBeginning(activity.getRootTracer());
    }

    public void startTransactionIfBeginning(Tracer tracer) {
        if (tracer instanceof TransactionActivityInitiator) {
            Agent.LOG.log(Level.FINER, "Starting transaction {0}", new Object[]{this});
            if (this.rootTracer == null) {
                this.rootTracer = tracer;
            }
            if (this.transactionTime == null) {
                this.transactionTime = new TransactionTimer(tracer.getStartTime());
                Agent.LOG.log(Level.FINER, "Set timer for transaction {0}", new Object[]{this});
            }
            if (this.dispatcher == null) {
                this.setDispatcher(((TransactionActivityInitiator)((Object)tracer)).createDispatcher());
            }
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        Agent.LOG.log(Level.FINER, "Set dispatcher {0} for transaction {1}", new Object[]{dispatcher, this});
        this.dispatcher = dispatcher;
    }

    public TransactionTimer getTransactionTimer() {
        return this.transactionTime;
    }

    private void finishTransaction() {
        String requestURI = this.dispatcher == null ? "No Dispatcher Defined" : this.dispatcher.getUri();
        IRPMService rpmService = this.getRPMService();
        this.beforeSendResponseHeaders();
        this.freezeTransactionName();
        if (this.ignore || this.finishedChildren.isEmpty()) {
            Agent.LOG.log(Level.FINE, "Ignoring transaction {0}", new Object[]{this});
            return;
        }
        if (this.isAsyncTransaction()) {
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Async transaction {1} finished {0}", requestURI, this);
                Agent.LOG.finest(msg);
            }
            return;
        }
        TransactionStats transactionStats = this.transactionFinishedActivityMerging();
        this.recordFinalGCTime(transactionStats);
        this.addUnStartedAsyncKeys(transactionStats);
        String txName = this.priorityTransactionName.getName();
        this.dispatcher.transactionFinished(txName, transactionStats);
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, "Transaction {2} finished {0}ms {1}", new Object[]{this.transactionTime.getResponseTimeInMilliseconds(), requestURI, this});
        }
        if (!ServiceFactory.getServiceManager().isStarted()) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, "Transaction name for {0} is {1}", new Object[]{requestURI, txName});
            if (this.isAutoAppNamingEnabled()) {
                Agent.LOG.log(Level.FINER, "Application name for {0} is {1}", new Object[]{txName, rpmService.getApplicationName()});
            }
        }
        boolean forcePersist = this.getBeaconTransactionState().getGuid() != null;
        TransactionTracerConfig ttConfig = this.getTransactionTracerConfig();
        if (this.isInteresting()) {
            String tripId;
            String referrerGuid;
            String clientCrossProcessId;
            int count;
            if (this.counts.isOverTracerSegmentLimit()) {
                this.getIntrinsicAttributes().put("segment_clamp", this.counts.getSegmentCount());
            }
            if (this.counts.isOverTransactionSize()) {
                this.getIntrinsicAttributes().put("size_limit", "The transaction size limit was reached");
            }
            if ((count = this.counts.getStackTraceCount()) >= ttConfig.getMaxStackTraces()) {
                this.getIntrinsicAttributes().put("stack_trace_clamp", count);
            }
            if ((count = this.counts.getExplainPlanCount()) >= ttConfig.getMaxExplainPlans()) {
                this.getIntrinsicAttributes().put("explain_plan_clamp", count);
            }
            if ((clientCrossProcessId = this.getCrossProcessTransactionState().getClientCrossProcessId()) != null && clientCrossProcessId.length() > 0) {
                this.getIntrinsicAttributes().put("client_cross_process_id", clientCrossProcessId);
            }
            if ((referrerGuid = this.getCrossProcessTransactionState().getReferrerGuid()) != null) {
                this.getIntrinsicAttributes().put("referring_transaction_guid", referrerGuid);
            }
            if ((tripId = this.getCrossProcessTransactionState().getTripId()) != null) {
                this.getIntrinsicAttributes().put("trip_id", tripId);
                int pathHash = this.getCrossProcessTransactionState().generatePathHash();
                this.getIntrinsicAttributes().put("path_hash", ServiceUtils.intToHexString(pathHash));
            }
        }
        this.getAgentAttributes().put("jvm.thread_name", Thread.currentThread().getName());
        TransactionData transactionData = new TransactionData(this, this.counts.getTransactionSize(), forcePersist);
        ServiceFactory.getTransactionService().processTransaction(transactionData, transactionStats);
    }

    private TransactionStats transactionFinishedActivityMerging() {
        Object val;
        TransactionStats transactionStats = null;
        long totalCpuTime = !this.isTransactionTraceEnabled() || this.getRunningDurationInNanos() <= this.getTransactionTracerConfig().getTransactionThresholdInNanos() ? -1L : ((val = this.getIntrinsicAttributes().remove("cpu_time")) != null && val instanceof Long ? (Long)val : 0L);
        for (TransactionActivity kid : this.getFinishedChildren()) {
            long tempCpuTime;
            if (transactionStats == null) {
                transactionStats = kid.getTransactionStats();
            } else {
                TransactionStats stats = kid.getTransactionStats();
                transactionStats.getScopedStats().mergeStats(stats.getScopedStats());
                transactionStats.getUnscopedStats().mergeStats(stats.getUnscopedStats());
            }
            if (kid.getRootTracer() != null) {
                Map<String, Object> tracerParams;
                Tracer rootTracer = kid.getRootTracer();
                this.transactionTime.incrementTransactionTotalTime(rootTracer.getDuration());
                this.transactionTime.setTransactionEndTimeIfLonger(rootTracer.getEndTime());
                if (Agent.LOG.isFinestEnabled() && (tracerParams = rootTracer.getParameters()) != null && !tracerParams.isEmpty()) {
                    Agent.LOG.log(Level.FINEST, "Parameters for {0} are {1}", new Object[]{rootTracer, tracerParams});
                }
            }
            if (totalCpuTime <= -1L) continue;
            long l = tempCpuTime = kid.getTotalCpuTime() > -1L ? kid.getTotalCpuTime() : -1L;
            if (tempCpuTime == -1L) {
                totalCpuTime = -1L;
                continue;
            }
            totalCpuTime += tempCpuTime;
        }
        if (totalCpuTime > 0L) {
            this.getIntrinsicAttributes().put("cpu_time", totalCpuTime);
        }
        return transactionStats;
    }

    public synchronized void addTotalCpuTimeForLegacy(long time) {
        Object val = this.getIntrinsicAttributes().remove("cpu_time");
        long totalCpuTime = val != null && val instanceof Long ? (Long)val : 0L;
        if (totalCpuTime != -1L) {
            totalCpuTime += time;
        }
        this.getIntrinsicAttributes().put("cpu_time", totalCpuTime);
    }

    public void recordFinalGCTime(TransactionStats stats) {
        long gcTime;
        Long totalGCTime;
        if (this.isTransactionTraceEnabled() && this.getRunningDurationInNanos() > this.getTransactionTracerConfig().getTransactionThresholdInNanos() && (totalGCTime = (Long)this.getIntrinsicAttributes().get("gc_time")) == null && this.startGCTimeInMillis > -1L && (gcTime = Transaction.getGCTime()) != this.startGCTimeInMillis) {
            totalGCTime = gcTime - this.startGCTimeInMillis;
            this.getIntrinsicAttributes().put("gc_time", totalGCTime);
            stats.getUnscopedStats().getResponseTimeStats("GC/cumulative").recordResponseTime(totalGCTime, TimeUnit.MILLISECONDS);
        }
    }

    private void addUnStartedAsyncKeys(TransactionStats stats) {
        if (!this.timedOutKeys.isEmpty()) {
            stats.getUnscopedStats().getStats("Supportability/Timeout/startAsyncNotCalled").setCallCount(this.timedOutKeys.size());
        }
        if (this.isTransactionTraceEnabled()) {
            for (Map.Entry<Object, Tracer> current : this.timedOutKeys.entrySet()) {
                Object val = current.getValue().getParameters().get("unstarted_async_activity");
                Map keys = val == null ? Maps.newHashMap() : (Map)val;
                String classType = current.getKey().getClass().toString();
                Integer count = (Integer)keys.get(classType);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                keys.put(classType, count);
                current.getValue().getParameters().put("unstarted_async_activity", keys);
            }
        }
    }

    public boolean isTransactionTraceEnabled() {
        return this.ttEnabled;
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    public boolean isTransactionNamingEnabled() {
        return this.transactionNamingEnabled;
    }

    public boolean isWebTransaction() {
        return this.dispatcher != null && this.dispatcher.isWebTransaction();
    }

    public boolean isAsyncTransaction() {
        return this.dispatcher != null && this.dispatcher.isAsyncTransaction();
    }

    public IRPMService getRPMService() {
        return ServiceFactory.getRPMServiceManager().getOrCreateRPMService(this.getPriorityApplicationName());
    }

    public static void clearTransaction() {
        Transaction tx = transactionHolder.get();
        if (tx != null) {
            tx.legacyState.boundThreads.remove(Thread.currentThread().getId());
        }
        transactionHolder.remove();
        TransactionActivity.clear();
    }

    public static void setTransaction(Transaction tx) {
        tx.legacyState.boundThreads.add(Thread.currentThread().getId());
        TransactionActivity.set(tx.initialActivity);
        transactionHolder.set(tx);
    }

    public static void setMockTransaction(Transaction tx) {
        transactionHolder.set(tx);
    }

    public static Transaction getTransaction() {
        return Transaction.getTransaction(true);
    }

    public static Transaction getTransaction(boolean createIfNotExists) {
        Transaction tx = transactionHolder.get();
        if (tx == null && createIfNotExists && !(Thread.currentThread() instanceof ThreadService.AgentThread)) {
            tx = new Transaction();
            tx.postConstruct();
            ServiceFactory.getTransactionService().addTransaction(tx);
            tx.legacyState.boundThreads.add(Thread.currentThread().getId());
            transactionHolder.set(tx);
        }
        return tx;
    }

    public static boolean hasTransaction() {
        return Transaction.getTransaction(false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setNormalizedUri(String normalizedUri) {
        Object object = this.lock;
        synchronized (object) {
            if (normalizedUri == null || normalizedUri.length() == 0) {
                return;
            }
            TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
            if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(this, TransactionNamePriority.CUSTOM_HIGH)) {
                String msg = MessageFormat.format("Setting transaction name to normalized URI \"{0}\"", normalizedUri);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(this, normalizedUri, "NormalizedUri", TransactionNamePriority.CUSTOM_HIGH);
            this.normalizedUri = normalizedUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getNormalizedUri() {
        Object object = this.lock;
        synchronized (object) {
            return this.normalizedUri;
        }
    }

    public Throwable getReportError() {
        return ServletUtils.getReportError(this.throwable.get());
    }

    public int getStatus() {
        return this.getWebResponse().getStatus();
    }

    public String getStatusMessage() {
        return this.getWebResponse().getStatusMessage();
    }

    public void freezeStatus() {
        this.getWebResponse().freezeStatus();
    }

    public void setThrowable(Throwable throwable) {
        this.setThrowable(throwable, false);
    }

    public void setThrowable(Throwable throwable, boolean force) {
        if (throwable == null) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, "Request to set throwable in transaction: {0}", new Object[]{throwable.getClass().getName()});
        }
        if (force || TransactionActivity.get() == this.initialActivity) {
            Agent.LOG.log(Level.FINER, "Set throwable in transaction: {0}", new Object[]{throwable.getClass().getName()});
            this.throwable.set(throwable);
        } else {
            Agent.LOG.log(Level.FINER, "setThrowable from asynchronous activity ignored: {0}", throwable);
        }
    }

    public void setThrowableIfNone(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, "Request to set throwable in transaction: {0}", new Object[]{throwable.getClass().getName()});
        }
        if (TransactionActivity.get() == this.initialActivity && this.throwable.compareAndSet(null, throwable)) {
            Agent.LOG.log(Level.FINER, "Set throwable in transaction: {0}", new Object[]{throwable.getClass().getName()});
        } else {
            Agent.LOG.log(Level.FINER, "setThrowable from asynchronous activity ignored: {0}", throwable);
        }
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    public void ignore() {
        this.setIgnore(true);
    }

    public void setIgnore(boolean ignore) {
        if (this.dispatcher != null) {
            this.ignore = ignore;
        } else {
            Agent.LOG.log(Level.FINEST, "setIgnore called outside of an open transaction");
        }
    }

    public void ignoreApdex() {
        if (this.dispatcher != null) {
            this.dispatcher.setIgnoreApdex(true);
        } else {
            Agent.LOG.finer("ignoreApdex invoked with no transaction");
        }
    }

    public TransactionCounts getTransactionCounts() {
        return this.counts;
    }

    public boolean shouldGenerateTransactionSegment() {
        return this.ttEnabled && this.counts.shouldGenerateTransactionSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatementParser getDatabaseStatementParser() {
        Object object = this.lock;
        synchronized (object) {
            if (this.databaseStatementParser == null) {
                this.databaseStatementParser = this.createDatabaseStatementParser();
            }
            return this.databaseStatementParser;
        }
    }

    private DatabaseStatementParser createDatabaseStatementParser() {
        return new CachingDatabaseStatementParser(ServiceFactory.getDatabaseService().getDatabaseStatementParser());
    }

    private boolean isInteresting() {
        if (this.throwable != null) {
            return true;
        }
        if (this.getStatus() >= 400) {
            return true;
        }
        if (!this.ttEnabled) {
            return false;
        }
        if (this.getBeaconTransactionState().getGuid() != null) {
            return true;
        }
        if (this.transactionTime.getResponseTime() <= this.getTransactionTracerConfig().getTransactionThresholdInNanos()) {
            return false;
        }
        return ServiceFactory.getTransactionTraceService().isInteresting(this.dispatcher, this.transactionTime.getResponseTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeaconTransactionState getBeaconTransactionState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.beaconTransactionState == null) {
                this.beaconTransactionState = BeaconTransactionStateImpl.create(this);
            }
            return this.beaconTransactionState;
        }
    }

    public CrossProcessState getCrossProcessState() {
        return this.getCrossProcessTransactionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrossProcessTransactionState getCrossProcessTransactionState() {
        Transaction tx;
        Transaction transaction = tx = this.getRootTransaction();
        synchronized (transaction) {
            if (tx.crossProcessTransactionState == null) {
                tx.crossProcessTransactionState = CrossProcessTransactionStateImpl.create(this);
            }
            return tx.crossProcessTransactionState;
        }
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    public Transaction getRootTransaction() {
        if (this.legacyState.rootTransaction == null) {
            return this;
        }
        return this.legacyState.rootTransaction;
    }

    public void setRootTransaction(Transaction tx) {
        if (this != tx) {
            this.legacyState.rootTransaction = tx;
        }
    }

    public void beforeSendResponseHeaders() {
        this.getCrossProcessTransactionState().writeResponseHeaders();
    }

    public WebResponse getWebResponse() {
        if (this.dispatcher instanceof WebResponse) {
            return (WebResponse)this.dispatcher;
        }
        return DEFAULT_RESPONSE;
    }

    public void convertToWebTransaction() {
        if (!this.isWebTransaction()) {
            this.setDispatcher(new WebRequestDispatcher(DUMMY_REQUEST, DUMMY_RESPONSE, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(Request request, Response response) {
        Agent.LOG.log(Level.FINEST, "Request initialized: {0}", new Object[]{request.getRequestURI()});
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            if (this.isFinished()) {
                return;
            }
            if (this.dispatcher == null) {
                ExitTracer tracer = AgentBridge.instrumentation.createTracer((com.newrelic.agent.bridge.Transaction)new TransactionApiImpl(this), null, REQUEST_INITIALIZED_CLASS_SIGNATURE.getClassName(), REQUEST_INITIALIZED_CLASS_SIGNATURE.getMethodName(), REQUEST_INITIALIZED_CLASS_SIGNATURE.getMethodDesc(), REQUEST_INITIALIZED_CLASS_SIGNATURE_ID, null, 14);
                if (tracer != null) {
                    if (response == null) {
                        response = DUMMY_RESPONSE;
                    }
                    this.setDispatcher(new WebRequestDispatcher(request, response, this));
                }
            } else {
                Agent.LOG.finer("requestInitialized(): transaction already started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed() {
        Agent.LOG.log(Level.FINEST, "Request destroyed");
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            if (!this.isInProgress()) {
                return;
            }
            Tracer rootTracer = this.getTransactionActivity().getRootTracer();
            Tracer lastTracer = this.getTransactionActivity().getLastTracer();
            if (lastTracer != null && rootTracer == lastTracer) {
                lastTracer.finish(177, null);
            } else {
                Agent.LOG.log(Level.FINER, "Inconsistent state!  tracer != last tracer for {0} ({1} != {2})", new Object[]{this, rootTracer, lastTracer});
            }
        }
    }

    public boolean isWebRequestSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_REQUEST.equals(this.dispatcher.getRequest());
        }
        return false;
    }

    public boolean isWebResponseSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_RESPONSE.equals(this.dispatcher.getResponse());
        }
        return false;
    }

    public void setWebRequest(Request request) {
        NewRelic.getAgent().getLogger().log(Level.FINEST, "setWebRequest invoked", new Object[0]);
        if (!(this.dispatcher instanceof WebRequestDispatcher)) {
            this.setDispatcher(new WebRequestDispatcher(request, DUMMY_RESPONSE, Transaction.getTransaction()));
        } else {
            this.dispatcher.setRequest(request);
        }
    }

    public void setWebResponse(Response response) {
        NewRelic.getAgent().getLogger().log(Level.FINEST, "setWebResponse invoked", new Object[0]);
        if (this.dispatcher instanceof WebRequestDispatcher) {
            this.dispatcher.setResponse(response);
        }
    }

    public static boolean isDummyRequest(Request request) {
        return request == DUMMY_REQUEST;
    }

    @Override
    public String getApplicationName() {
        return this.getPriorityApplicationName().getName();
    }

    public PriorityApplicationName getPriorityApplicationName() {
        return this.priorityApplicationName;
    }

    public void setApplicationName(ApplicationNamePriority priority, String appName) {
        this.setApplicationName(priority, appName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setApplicationName(ApplicationNamePriority priority, String appName, boolean override) {
        if (appName == null || appName.length() == 0) {
            return;
        }
        AbstractApplicationNamingPolicy policy = override ? SameOrHigherPriorityApplicationNamingPolicy.getInstance() : HigherPriorityApplicationNamingPolicy.getInstance();
        Object object = this.lock;
        synchronized (object) {
            if (policy.canSetApplicationName(this, priority)) {
                String name = Transaction.stripLeadingForwardSlash(appName);
                PriorityApplicationName pan = PriorityApplicationName.create(name, priority);
                this.setPriorityApplicationName(pan);
            }
        }
    }

    private static String stripLeadingForwardSlash(String appName) {
        String FORWARD_SLASH = "/";
        if (appName.length() > 1 && appName.startsWith("/")) {
            return appName.substring(1, appName.length());
        }
        return appName;
    }

    private void setPriorityApplicationName(PriorityApplicationName pan) {
        if (pan == null || pan.equals(this.priorityApplicationName)) {
            return;
        }
        this.priorityApplicationName = pan;
        Agent.LOG.log(Level.FINE, "Set application name to {0}", new Object[]{pan.getName()});
        this.agentConfig = null;
    }

    @Override
    public long getRunningDurationInNanos() {
        if (this.dispatcher == null) {
            return 0L;
        }
        return this.transactionTime.getRunningDurationInNanos();
    }

    public void saveMessageParameters(Map<String, String> parameters) {
        MessagingUtil.recordParameters(this, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerAsyncActivity(Object activityContext) {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isInProgress()) {
                Tracer t = this.getTransactionActivity().getLastTracer();
                if (t == null) {
                    Agent.LOG.log(Level.FINE, "Parent tracer not found. Not registering async activity context {0} with transaction {1}", new Object[]{activityContext, this});
                } else if (!pendingActivities.putIfAbsent(activityContext, this)) {
                    Agent.LOG.log(Level.FINER, "Key already in use. Not registering async activity context {0} with transaction {1}", new Object[]{activityContext, this});
                } else {
                    this.contextToTracer.put(activityContext, t);
                    Agent.LOG.log(Level.FINER, "Registering async activity context {0} with transaction {1}", new Object[]{activityContext, this});
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAsyncActivity(Object activityContext) {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isInProgress()) {
                Transaction transaction = pendingActivities.extractIfPresent(activityContext);
                if (transaction == null) {
                    Agent.LOG.log(Level.FINER, "startAsyncActivity(): there is no transaction associated with context {0}", new Object[]{activityContext});
                } else if (transaction == this) {
                    Agent.LOG.log(Level.FINER, "Transaction started in current running transaction {0} for context {1}", new Object[]{transaction, activityContext});
                    this.contextToTracer.remove(activityContext);
                } else {
                    result = true;
                    this.migrate(transaction, activityContext);
                    Agent.LOG.log(Level.FINER, "startAsyncActivity(): activity {0} (context {1}) unbound from transaction {2} and bound to {3}", new Object[]{this.getTransactionActivity(), activityContext, this, transaction});
                }
            } else {
                Agent.LOG.log(Level.FINER, "startAsyncActivity must be called within a transaction.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutAsyncActivity(Object activityContext) {
        Object object = this.lock;
        synchronized (object) {
            Tracer tracer = this.contextToTracer.remove(activityContext);
            if (tracer != null) {
                this.timedOutKeys.put(activityContext, tracer);
                this.checkFinishTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ignoreAsyncActivity(Object activityContext) {
        String baseMessage = "ignoreAsyncActivity({0}): {1}";
        boolean result = true;
        Object object = this.lock;
        synchronized (object) {
            String detailMessage = null;
            Transaction tx = pendingActivities.extractIfPresent(activityContext);
            if (tx != null) {
                Tracer t = tx.contextToTracer.remove(activityContext);
                if (t == null) {
                    Agent.LOG.log(Level.FINER, "ignoreAsyncActivity({0}): {1}", new Object[]{activityContext, "tracer not found"});
                }
                detailMessage = "pending activity ignored.";
            } else if (this.runningChildren.containsKey(activityContext)) {
                TransactionActivity txa = this.runningChildren.remove(activityContext);
                txa.setToIgnore();
                detailMessage = "running activity ignored.";
            } else if (this.finishedChildren.containsKey(activityContext)) {
                TransactionActivity txa = this.finishedChildren.remove(activityContext);
                txa.setToIgnore();
                detailMessage = "finished activity ignored.";
            } else {
                detailMessage = "activity not found.";
                result = false;
            }
            Agent.LOG.log(Level.FINE, "ignoreAsyncActivity({0}): {1}", new Object[]{activityContext, detailMessage});
            this.checkFinishTransaction();
        }
        return result;
    }

    private void migrate(Transaction newTrans, Object context) {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        if (this == newTrans) {
            return;
        }
        TransactionActivity activity = this.getTransactionActivity();
        Tracer tracer = newTrans.contextToTracer.remove(context);
        activity.startAsyncActivity(context, newTrans, tracer);
        newTrans.runningChildren.put(context, activity);
        transactionHolder.set(newTrans);
        newTrans.legacyState.boundThreads.add(Thread.currentThread().getId());
        PriorityApplicationName pan = this.getPriorityApplicationName();
        newTrans.setApplicationName(pan.getPriority(), pan.getName(), true);
        PriorityTransactionName ptn = this.getPriorityTransactionName();
        newTrans.setTransactionName(ptn.getPriority(), true, ptn.getCategory(), ptn.getName());
        newTrans.getInternalParameters().putAll(this.getInternalParameters());
        newTrans.getPrefixedAgentAttributes().putAll(this.getPrefixedAgentAttributes());
        newTrans.getAgentAttributes().putAll(this.getAgentAttributes());
        newTrans.getIntrinsicAttributes().putAll(this.getIntrinsicAttributes());
        newTrans.getUserAttributes().putAll(this.getUserAttributes());
        newTrans.getErrorAttributes().putAll(this.getErrorAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransactionActivity> getFinishedChildren() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<TransactionActivity>(this.finishedChildren.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFinished(TransactionActivity activity, Tracer tracer, int opcode) {
        Agent.LOG.log(Level.FINER, "Activity {0} with context {1} finished with opcode {2} in transaction {3}.", new Object[]{activity, activity.getContext(), opcode, this});
        Object object = this.lock;
        synchronized (object) {
            try {
                Object context = activity.getContext();
                if (this.runningChildren.remove(context) == null) {
                    Agent.LOG.log(Level.FINE, "The completing activity {0} was not in the running list for transaction {1}", new Object[]{activity, this});
                } else {
                    this.finishedChildren.put(context, activity);
                }
                this.checkFinishTransaction();
            }
            finally {
                this.legacyState.boundThreads.remove(Thread.currentThread().getId());
                transactionHolder.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFailed(TransactionActivity activity, int opcode) {
        Agent.LOG.log(Level.FINER, "activity {0} FAILED with opcode {1}", new Object[]{activity, opcode});
        Object object = this.lock;
        synchronized (object) {
            try {
                this.runningChildren.remove(activity.getContext());
                this.finishedChildren.remove(activity.getContext());
                this.checkFinishTransaction();
            }
            finally {
                this.legacyState.boundThreads.remove(Thread.currentThread().getId());
                transactionHolder.remove();
            }
        }
    }

    private void checkFinishTransaction() {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        if (this.runningChildren.isEmpty() && this.contextToTracer.isEmpty()) {
            this.finishTransaction();
        }
    }

    private final void threadAssertion() {
        if (Agent.LOG.isFinestEnabled() && !Thread.holdsLock(this.lock)) {
            Agent.LOG.log(Level.FINEST, THREAD_ASSERTION_FAILURE, new Exception(THREAD_ASSERTION_FAILURE).fillInStackTrace());
        }
    }

    private static class LegacyState {
        volatile Transaction rootTransaction;
        final Set<Long> boundThreads;

        LegacyState() {
            MapMaker factory = new MapMaker().initialCapacity(8).concurrencyLevel(4);
            this.boundThreads = Sets.newSetFromMap(new LazyMapImpl(factory));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PendingActivities {
        private static final RemovalListener<Object, Transaction> removalListener = new RemovalListener<Object, Transaction>(){

            @Override
            public void onRemoval(RemovalNotification<Object, Transaction> notification) {
                RemovalCause cause = notification.getCause();
                if (cause == RemovalCause.EXPLICIT) {
                    Agent.LOG.log(Level.FINEST, "{2}: Key {0} with transaction {1} removed from cache.", new Object[]{notification.getKey(), notification.getValue(), cause});
                } else {
                    Agent.LOG.log(Level.FINE, "{2}: The registered async activity with async context {0} has timeout for transaction {1}. It will not be included in the Transaction.", new Object[]{notification.getKey(), notification.getValue(), cause});
                    notification.getValue().timeoutAsyncActivity(notification.getKey());
                }
            }
        };
        private static final Cache<Object, Transaction> pendingActivities = PendingActivities.makeCache(removalListener);

        private PendingActivities() {
        }

        private static final Cache<Object, Transaction> makeCache(RemovalListener<Object, Transaction> removalListener) {
            long timoutSec = ((Integer)ServiceFactory.getConfigService().getDefaultAgentConfig().getValue("async_timeout", 180)).intValue();
            return CacheBuilder.newBuilder().weakKeys().expireAfterWrite(timoutSec, TimeUnit.SECONDS).removalListener(removalListener).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction extractIfPresent(Object key) {
            Transaction result = null;
            Cache<Object, Transaction> cache = pendingActivities;
            synchronized (cache) {
                result = pendingActivities.getIfPresent(key);
                if (result != null) {
                    pendingActivities.invalidate(key);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean putIfAbsent(Object key, Transaction tx) {
            boolean result = false;
            Cache<Object, Transaction> cache = pendingActivities;
            synchronized (cache) {
                if (pendingActivities.getIfPresent(key) == null) {
                    pendingActivities.put(key, tx);
                    result = true;
                }
            }
            return result;
        }

        public void cleanUp() {
            pendingActivities.cleanUp();
            Agent.LOG.log(Level.INFO, "Transaction: allPendingActivities cache cleared.");
        }
    }
}

