/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.SimpleStatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.transaction.TransactionCache;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionActivity {
    public static final int NOT_REPORTED = -1;
    private final List<Tracer> tracers;
    private int tracerStartLock = 0;
    private Tracer rootTracer;
    private Tracer lastTracer;
    private final TransactionStats transactionStats;
    private Transaction transaction;
    private final TransactionCache transactionCache;
    private final String threadName;
    private final long cpuStartTimeInNanos;
    private long totalCpuTimeInNanos;
    private boolean ignoreMe = false;
    private Object context = null;
    private static final ThreadLocal<TransactionActivity> activityHolder = new ThreadLocal<TransactionActivity>(){

        @Override
        public TransactionActivity get() {
            return (TransactionActivity)super.get();
        }

        @Override
        public void set(TransactionActivity value) {
            super.set(value);
        }

        @Override
        public void remove() {
            super.remove();
        }
    };
    private static final Tracer FLYWEIGHT_PLACEHOLDER = new Tracer(){

        public void setMetricName(String ... metricNameParts) {
        }

        public TracedMethod getParentTracedMethod() {
            return null;
        }

        public void finish(Throwable throwable) {
        }

        public void finish(int opcode, Object returnValue) {
        }

        @Override
        public long getDurationInMilliseconds() {
            return 0L;
        }

        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }

        @Override
        public boolean isTransactionSegment() {
            return false;
        }

        @Override
        public boolean isParent() {
            return false;
        }

        @Override
        public void setParentTracer(Tracer tracer) {
        }

        @Override
        public boolean isMetricProducer() {
            return true;
        }

        @Override
        public boolean isChildHasStackTrace() {
            return false;
        }

        @Override
        public String getTransactionSegmentUri() {
            return null;
        }

        @Override
        public String getTransactionSegmentName() {
            return null;
        }

        @Override
        public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
            return null;
        }

        @Override
        public Throwable getThrowable() {
            return null;
        }

        @Override
        public long getStartTimeInMilliseconds() {
            return 0L;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getRunningDurationInNanos() {
            return 0L;
        }

        @Override
        public Tracer getParentTracer() {
            return null;
        }

        @Override
        public Map<String, Object> getParameters() {
            return Collections.emptyMap();
        }

        @Override
        public String getMetricName() {
            return null;
        }

        @Override
        public long getExclusiveDuration() {
            return 0L;
        }

        @Override
        public long getEndTimeInMilliseconds() {
            return 0L;
        }

        @Override
        public long getEndTime() {
            return 0L;
        }

        @Override
        public ClassMethodSignature getClassMethodSignature() {
            return null;
        }

        @Override
        public void childTracerFinished(Tracer child) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public void setRollupMetricNames(String ... metricNames) {
        }

        public void nameTransaction(TransactionNamePriority namePriority) {
        }

        public void addRollupMetricName(String ... metricNameParts) {
        }
    };

    public static void clear() {
        activityHolder.remove();
        Agent.LOG.log(Level.FINEST, "TransactionActivity.clear()");
    }

    public static void set(TransactionActivity txa) {
        activityHolder.set(txa);
        Agent.LOG.log(Level.FINEST, "TransactionActivity.set({0})", new Object[]{txa});
    }

    public static TransactionActivity get() {
        TransactionActivity result = activityHolder.get();
        return result;
    }

    public static TransactionActivity create(Transaction transaction) {
        TransactionActivity txa = new TransactionActivity(transaction);
        activityHolder.set(txa);
        Agent.LOG.log(Level.FINE, "created {0} for {1}", new Object[]{txa, transaction});
        return txa;
    }

    private TransactionActivity(Transaction tx) {
        this.transaction = tx;
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.tracers = ttService.isEnabled() ? new ArrayList(128) : null;
        this.transactionStats = new TransactionStats();
        this.transactionCache = new TransactionCache();
        Thread thread = Thread.currentThread();
        this.threadName = thread.getName();
        if (ttService.isEnabled()) {
            if (ttService.isThreadCpuTimeEnabled()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                this.cpuStartTimeInNanos = threadMXBean.getCurrentThreadCpuTime();
                this.totalCpuTimeInNanos = 0L;
            } else {
                this.cpuStartTimeInNanos = -1L;
                this.totalCpuTimeInNanos = -1L;
            }
        } else {
            this.cpuStartTimeInNanos = -1L;
            this.totalCpuTimeInNanos = -1L;
        }
    }

    public TransactionActivity() {
        String realClassName = this.getClass().getSimpleName();
        if (!realClassName.startsWith("Mock")) {
            throw new IllegalStateException("the public constructor is only for test purposes.");
        }
        this.tracers = null;
        this.transactionStats = null;
        this.transactionCache = null;
        this.threadName = "MockThread";
        this.cpuStartTimeInNanos = -1L;
        this.totalCpuTimeInNanos = -1L;
    }

    public Object getContext() {
        if (this.context == null) {
            Agent.LOG.log(Level.FINE, "TransactionActivity: context is null.");
        }
        return this.context;
    }

    public void setContext(Object context) {
        if (context == null) {
            Agent.LOG.log(Level.FINE, "TransactionActivity: context is being set to null.");
        }
        this.context = context;
    }

    public TransactionStats getTransactionStats() {
        return this.transactionStats;
    }

    public List<Tracer> getTracers() {
        return Collections.unmodifiableList(this.tracers);
    }

    public long getTotalCpuTime() {
        return this.totalCpuTimeInNanos;
    }

    public void setToIgnore() {
        this.ignoreMe = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tracer tracerStarted(Tracer tracer) {
        if (this.isTracerStartLocked()) {
            Agent.LOG.log(Level.FINER, "tracerStarted ignored: tracerStartLock is already active");
            return null;
        }
        if (!this.isStarted()) {
            if (tracer instanceof TransactionActivityInitiator) {
                this.setRootTracer(tracer);
                return tracer;
            }
            Transaction.clearTransaction();
            activityHolder.remove();
            return null;
        }
        if (tracer.getParentTracer() != null) {
            this.lastTracer = tracer;
            this.addTracer(tracer);
            return tracer;
        }
        if (!Agent.LOG.isFinestEnabled()) return tracer;
        Agent.LOG.log(Level.FINEST, "tracerStarted: {0} cannot be added: no parent pointer", new Object[]{tracer});
        return tracer;
    }

    public void tracerFinished(Tracer tracer, int opcode) {
        if (tracer instanceof SkipTracer) {
            return;
        }
        if (tracer != this.lastTracer) {
            this.failed(this, tracer, opcode);
        } else if (tracer == this.rootTracer) {
            this.finished(this.rootTracer, opcode);
        } else {
            this.lastTracer = tracer.getParentTracer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failed(TransactionActivity activity, Tracer tracer, int opcode) {
        Agent.LOG.log(Level.SEVERE, "Inconsistent state!  tracer != last tracer for {0} ({1} != {2})", new Object[]{this, tracer, this.lastTracer});
        try {
            this.transaction.activityFailed(this, opcode);
        }
        finally {
            activityHolder.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(Tracer tracer, int opcode) {
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.log(Level.FINEST, "tracerFinished: {0} opcode: {1} in transactionActivity {2}", new Object[]{tracer, opcode, this});
        }
        try {
            if (!this.ignoreMe) {
                this.recordCpu();
            }
            this.transaction.activityFinished(this, tracer, opcode);
        }
        finally {
            activityHolder.remove();
        }
    }

    private boolean isStarted() {
        return this.rootTracer != null;
    }

    public boolean isFlyweight() {
        return this.lastTracer != null && this.lastTracer.isLeaf();
    }

    public void recordCpu() {
        if (this.transaction.isTransactionTraceEnabled() && this.cpuStartTimeInNanos > -1L && this.totalCpuTimeInNanos == 0L) {
            this.totalCpuTimeInNanos = ServiceFactory.getTransactionTraceService().getThreadMXBean().getCurrentThreadCpuTime() - this.cpuStartTimeInNanos;
        }
    }

    public void addTracer(Tracer tracer) {
        if (tracer.isTransactionSegment()) {
            this.getTransaction().getTransactionCounts().addTracer();
            this.tracers.add(tracer);
        }
    }

    private void setRootTracer(Tracer tracer) {
        this.rootTracer = tracer;
        this.lastTracer = tracer;
        this.transaction.activityStarted(this);
        if (tracer instanceof DefaultTracer) {
            ((DefaultTracer)this.rootTracer).setParameter("exec_context", this.threadName);
        }
        this.getTransaction().getTransactionCounts().addTracer();
    }

    public void lockTracerStart() {
        --this.tracerStartLock;
    }

    public void unlockTracerStart() {
        ++this.tracerStartLock;
    }

    public boolean isTracerStartLocked() {
        return this.tracerStartLock < 0;
    }

    public Tracer getLastTracer() {
        return this.lastTracer;
    }

    public TracedMethod startFlyweightTracer() {
        try {
            if (this.rootTracer == null) {
                return null;
            }
            Tracer tracer = this.lastTracer;
            if (this.lastTracer.isLeaf()) {
                return null;
            }
            this.lastTracer = FLYWEIGHT_PLACEHOLDER;
            return tracer;
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, t, "Error starting tracer", new Object[0]);
            return null;
        }
    }

    public void finishFlyweightTracer(TracedMethod parent, long startInNanos, long finishInNanos, String className, String methodName, String methodDesc, String metricName, String[] rollupMetricNames) {
        try {
            if (parent instanceof DefaultTracer) {
                DefaultTracer parentTracer = (DefaultTracer)parent;
                long duration = finishInNanos - startInNanos;
                if (this.lastTracer == FLYWEIGHT_PLACEHOLDER) {
                    this.lastTracer = parentTracer;
                } else {
                    Agent.LOG.log(Level.FINEST, "Error finishing tracer - the last tracer is of the wrong type.");
                }
                if (duration < 0L) {
                    Agent.LOG.log(Level.FINEST, "A tracer finished with a negative duration.");
                    return;
                }
                this.transactionStats.getScopedStats().getResponseTimeStats(metricName).recordResponseTimeInNanos(duration);
                Agent.LOG.log(Level.FINEST, "Finished flyweight tracer {0} ({1}.{2}{3})", new Object[]{metricName, className, methodName, methodDesc});
                if (rollupMetricNames != null) {
                    SimpleStatsEngine unscopedStats = this.transactionStats.getUnscopedStats();
                    for (String name : rollupMetricNames) {
                        unscopedStats.getResponseTimeStats(name).recordResponseTimeInNanos(duration);
                    }
                }
                parentTracer.childTracerFinished(duration);
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, t, "Error finishing tracer", new Object[0]);
        }
    }

    public void startAsyncActivity(Object context, Transaction transaction, Tracer parentTracer) {
        this.setContext(context);
        this.transaction = transaction;
        if (parentTracer != null) {
            this.rootTracer.setParentTracer(parentTracer);
        } else {
            Agent.LOG.log(Level.FINE, "TranactionActivity.startAsyncActivity: parentTracer is null.");
        }
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public TransactionCache getTransactionCache() {
        return this.transactionCache;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

