/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.CrossProcessState;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.api.agent.ApplicationNamePriority;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionApiImpl
implements com.newrelic.agent.bridge.Transaction {
    private final Transaction boundTransaction;

    public TransactionApiImpl() {
        this.boundTransaction = null;
    }

    public TransactionApiImpl(Transaction boundTransaction) {
        if (boundTransaction == null) {
            throw new IllegalArgumentException("boundTransaction must not be null");
        }
        this.boundTransaction = boundTransaction;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionApiImpl)) {
            return false;
        }
        TransactionApiImpl objTxi = (TransactionApiImpl)obj;
        return this.getTransaction() == objTxi.getTransaction();
    }

    public int hashCode() {
        Transaction tx = this.getTransaction();
        return tx == null ? 42 : tx.hashCode();
    }

    public Transaction getTransaction() {
        if (this.boundTransaction != null) {
            return this.boundTransaction;
        }
        return Transaction.getTransaction(false);
    }

    public boolean registerAsyncActivity(Object asyncContext) {
        return this.getTransaction().registerAsyncActivity(asyncContext);
    }

    public boolean startAsyncActivity(Object asyncContext) {
        return this.getTransaction().startAsyncActivity(asyncContext);
    }

    public boolean ignoreAsyncActivity(Object asyncContext) {
        return this.getTransaction().ignoreAsyncActivity(asyncContext);
    }

    public boolean setTransactionName(com.newrelic.api.agent.TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.setTransactionName(namePriority, override, category, parts) : false;
    }

    public boolean isTransactionNameSet() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.isTransactionNameSet() : false;
    }

    public com.newrelic.api.agent.TracedMethod getLastTracer() {
        return this.getTracedMethod();
    }

    public com.newrelic.api.agent.TracedMethod getTracedMethod() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return null;
        }
        TransactionActivity txa = tx.getTransactionActivity();
        if (txa == null) {
            return null;
        }
        return txa.getLastTracer();
    }

    public void ignore() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.ignore();
        }
    }

    public void ignoreApdex() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.ignoreApdex();
        }
    }

    public boolean setTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.setTransactionName(namePriority, override, category, parts) : false;
    }

    public void beforeSendResponseHeaders() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.beforeSendResponseHeaders();
        }
    }

    public boolean isStarted() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.isStarted() : false;
    }

    public void setApplicationName(ApplicationNamePriority priority, String appName) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.setApplicationName(priority, appName);
        }
    }

    public boolean isAutoAppNamingEnabled() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.isAutoAppNamingEnabled() : false;
    }

    public boolean isWebRequestSet() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.isWebRequestSet() : false;
    }

    public boolean isWebResponseSet() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.isWebResponseSet() : false;
    }

    public void setWebRequest(Request request) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.setWebRequest(request);
        }
    }

    public void setWebResponse(Response response) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.setWebResponse(response);
        }
    }

    public WebResponse getWebResponse() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getWebResponse() : null;
    }

    public void convertToWebTransaction() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.convertToWebTransaction();
        }
    }

    public boolean isWebTransaction() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            return tx.isWebTransaction();
        }
        return false;
    }

    public void requestInitialized(Request request, Response response) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.requestInitialized(request, response);
        }
    }

    public void requestDestroyed() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.requestDestroyed();
        }
    }

    public void saveMessageParameters(Map<String, String> parameters) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.saveMessageParameters(parameters);
        }
    }

    public CrossProcessState getCrossProcessState() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getCrossProcessState() : null;
    }

    public TracedMethod startFlyweightTracer() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getTransactionActivity().startFlyweightTracer() : null;
    }

    public void finishFlyweightTracer(TracedMethod parent, long startInNanos, long finishInNanos, String className, String methodName, String methodDesc, String metricName, String[] rollupMetricNames) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.getTransactionActivity().finishFlyweightTracer(parent, startInNanos, finishInNanos, className, methodName, methodDesc, metricName, rollupMetricNames);
        }
    }

    public Map<String, Object> getAgentAttributes() {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getAgentAttributes() : null;
    }
}

