/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeSender {
    protected static String ATTRIBUTE_TYPE;

    protected abstract String getAttributeType();

    protected abstract Map<String, Object> getAttributeMap() throws Throwable;

    protected void addCustomAttributeImpl(String key, Object value) {
        block4: {
            Object filteredValue = this.verifyParameterAndReturnValue(key, value, "addAttribute");
            if (null == filteredValue) {
                return;
            }
            try {
                this.getAttributeMap().put(key, filteredValue);
                Agent.LOG.log(Level.FINER, "Added {0} attribute \"{1}\": {2}", new Object[]{this.getAttributeType(), key, filteredValue});
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attribute for key: \"{0}\": {1}", new Object[]{key, t});
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block4;
                Agent.LOG.log(Level.FINER, "Exception adding attribute for key: \"{0}\": {1}", new Object[]{key});
            }
        }
    }

    public Object verifyParameterAndReturnValue(String key, Object value, String methodCalled) {
        if (key == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null key", new Object[]{this.getAttributeType(), methodCalled});
            return null;
        }
        if (value == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null value for key \"{2}\"", new Object[]{this.getAttributeType(), methodCalled, key});
            return null;
        }
        try {
            Transaction tx = Transaction.getTransaction();
            if (key.length() > tx.getAgentConfig().getMaxUserParameterSize()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a key longer than {2} bytes. Key is \"{3}\".", new Object[]{this.getAttributeType(), methodCalled, tx.getAgentConfig().getMaxUserParameterSize(), key});
                return null;
            }
            if (value instanceof String && ((String)value).length() > tx.getAgentConfig().getMaxUserParameterSize()) {
                Agent.LOG.log(Level.FINER, "{0} was invoked with a value longer than {2} bytes for key \"{3}\". The value will be shortened.", new Object[]{methodCalled, value, tx.getAgentConfig().getMaxUserParameterSize(), key});
                return ((String)value).substring(0, tx.getAgentConfig().getMaxUserParameterSize());
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Exception while verifying attribute", t);
            return null;
        }
        return value;
    }

    public void addAttribute(String key, String value) {
        this.addCustomAttributeImpl(key, value);
    }

    public void addAttribute(String key, Number value) {
        this.addCustomAttributeImpl(key, value);
    }
}

