/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AttributeSender;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAttributeSender
extends AttributeSender {
    protected static String ATTRIBUTE_TYPE = "custom";

    @Override
    protected String getAttributeType() {
        return ATTRIBUTE_TYPE;
    }

    @Override
    protected Map<String, Object> getAttributeMap() throws Throwable {
        Transaction tx = Transaction.getTransaction();
        return tx.getUserAttributes();
    }

    @Override
    public Object verifyParameterAndReturnValue(String key, Object value, String methodCalled) {
        try {
            if (Transaction.getTransaction().getAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with key \"{2}\" while in high security mode.", new Object[]{this.getAttributeType(), methodCalled, key});
                return null;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Unable to veryify attribute. Exception thrown while verifying high security mode.", t);
            return null;
        }
        return super.verifyParameterAndReturnValue(key, value, methodCalled);
    }

    @Override
    protected void addCustomAttributeImpl(String key, Object value) {
        try {
            Transaction tx = Transaction.getTransaction();
            if (this.getAttributeMap().size() >= tx.getAgentConfig().getMaxUserParameters()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute for key \"{1}\" because the limit is {2}.", new Object[]{this.getAttributeType(), key, tx.getAgentConfig().getMaxUserParameters()});
                return;
            }
            super.addCustomAttributeImpl(key, value);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Exception adding {0} parameter for key: \"{1}\": {2}", new Object[]{this.getAttributeType(), key, t});
        }
    }
}

