/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.attributes.AttributesConfigUtil;
import com.newrelic.agent.attributes.DefaultDestinationPredicate;
import com.newrelic.agent.attributes.DestinationPredicate;
import com.newrelic.agent.attributes.DisabledDestinationPredicate;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationFilter {
    private final boolean isEnabled;
    private final DestinationPredicate filter;

    public DestinationFilter(String mainNameForFilter, boolean defaultInclude, AgentConfig config, List<String> confixExcludes, List<String> configIncludes, boolean captureParams, boolean captureMessageParams, String[] defaultExclude, String ... namesForIsEnabled) {
        this.isEnabled = AttributesConfigUtil.isAttsEnabled(config, defaultInclude, namesForIsEnabled);
        Agent.LOG.log(Level.FINE, "Attributes are {0} for {1}", new Object[]{this.isEnabled ? "enabled" : "disabled", mainNameForFilter});
        this.filter = DestinationFilter.getDestinationPredicate(this.isEnabled, config, confixExcludes, configIncludes, mainNameForFilter, DestinationFilter.updateDefaults(captureParams, captureMessageParams, defaultExclude));
    }

    private static DestinationPredicate getDestinationPredicate(boolean isEnabled, AgentConfig config, List<String> rootExcludes, List<String> rootIncludes, String name, Set<String> defaultExclude) {
        if (isEnabled) {
            Set<String> configExclude = AttributesConfigUtil.getExcluded(config, rootExcludes, name);
            Set<String> configInclude = AttributesConfigUtil.getIncluded(config, rootIncludes, name);
            return new DefaultDestinationPredicate(name, configExclude, configInclude, defaultExclude, DestinationFilter.getMandatoryExcludes(config.isHighSecurity()));
        }
        return new DisabledDestinationPredicate();
    }

    private static Set<String> getMandatoryExcludes(boolean highSecurity) {
        if (highSecurity) {
            return Sets.newHashSet("request.parameters.*", "message.parameters.*");
        }
        return Collections.emptySet();
    }

    private static Set<String> updateDefaults(boolean captureParams, boolean captureMessageParams, String[] defaultExclude) {
        HashSet<String> defaultExc = Sets.newHashSet(defaultExclude);
        if (!captureParams) {
            defaultExc.add("request.parameters.*");
        }
        if (!captureMessageParams) {
            defaultExc.add("message.parameters.*");
        }
        return defaultExc;
    }

    protected boolean isPotentialConfigMatch(String paramStart) {
        return this.filter.isPotentialConfigMatch(paramStart);
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected Map<String, ? extends Object> filterAttributes(Map<String, ? extends Object> values) {
        return this.filterAttributes(values, this.filter);
    }

    private Map<String, ? extends Object> filterAttributes(Map<String, ? extends Object> values, DestinationPredicate predicate) {
        return this.isEnabled && values != null && !values.isEmpty() ? Maps.filterKeys(values, predicate) : Collections.emptyMap();
    }
}

