/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.beacon.BeaconConfig;
import com.newrelic.agent.beacon.IBeaconConfig;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigFactory;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconConfigFactory {
    public static IBeaconConfig createBeaconConfig(String appName, Map<String, Object> serverData) {
        try {
            IBeaconConfig beaconConfig = BeaconConfigFactory.createTheBeaconConfig(appName, serverData);
            AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
            String autoInstrument = agentConfig.getBrowserMonitoringConfig().isAutoInstrumentEnabled() ? " with auto instrumentation" : "";
            String msg = MessageFormat.format("Real user monitoring is enabled{0} for application \"{1}\"", autoInstrument, appName);
            Agent.LOG.info(msg);
            return beaconConfig;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to configure application \"{0}\" for Real User Monitoring: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else {
                Agent.LOG.finer(msg);
            }
            Agent.LOG.info(MessageFormat.format("Real user monitoring is not enabled for application \"{0}\"", appName));
            return null;
        }
    }

    private static IBeaconConfig createTheBeaconConfig(String appName, Map<String, Object> serverData) throws Exception {
        Map<String, Object> settings = BeaconConfigFactory.createMap();
        BeaconConfigFactory.mergeBeaconSettings(settings, serverData);
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        BeaconConfigFactory.mergeBeaconSettings(settings, agentData);
        return BeaconConfig.createBeaconConfig(appName, settings);
    }

    private static void mergeBeaconSettings(Map<String, Object> settings, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        BeaconConfigFactory.mergeSetting("browser_key", settings, data);
        BeaconConfigFactory.mergeSetting("browser_monitoring.loader_version", settings, data);
        BeaconConfigFactory.mergeSetting("js_agent_loader", settings, data);
        BeaconConfigFactory.mergeSetting("js_agent_file", settings, data);
        BeaconConfigFactory.mergeSetting("beacon", settings, data);
        BeaconConfigFactory.mergeSetting("error_beacon", settings, data);
        BeaconConfigFactory.mergeSetting("application_id", settings, data);
    }

    private static void mergeSetting(String currentSetting, Map<String, Object> settings, Map<String, Object> data) {
        Object val = data.get(currentSetting);
        if (val != null) {
            settings.put(currentSetting, val);
        }
    }

    private static Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }
}

