/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.beacon.BeaconTransactionState;
import com.newrelic.agent.config.BrowserMonitoringConfig;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Obfuscator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconFooter {
    private static final String BEACON_KEY = "beacon";
    private static final String ERROR_BEACON_KEY = "errorBeacon";
    private static final String LICENSE_KEY = "licenseKey";
    private static final String APPLCATION_ID_KEY = "applicationID";
    private static final String TRANSACTION_NAME_KEY = "transactionName";
    private static final String QUEUE_TIME_KEY = "queueTime";
    private static final String APP_TIME_KEY = "applicationTime";
    private static final String TRAN_TRACE_GUID_KEY = "ttGuid";
    private static final String AGENT_TOKEN_KEY = "agentToken";
    private static final String ATTS_KEY = "atts";
    private static final String SSL_FOR_HTTP_KEY = "sslForHttp";
    private static final String AGENT_PAYLOAD_SCRIPT_KEY = "agent";
    public static final String FOOTER_START_SCRIPT = "\n<script type=\"text/javascript\">window.NREUM||(NREUM={});NREUM.info=";
    public static final String FOOTER_END = "</script>";
    private final String beacon;
    private final String browserKey;
    private final String errorBeacon;
    private final String payloadScript;
    private final String appId;
    private final Boolean isSslForHttp;

    public BeaconFooter(String appName, String pBeacon, String pBrowserKey, String pErrorBeacon, String pPayloadScript, String pAppId) {
        this.beacon = pBeacon;
        this.browserKey = pBrowserKey;
        this.errorBeacon = pErrorBeacon;
        this.payloadScript = pPayloadScript;
        this.appId = pAppId;
        BrowserMonitoringConfig config = ServiceFactory.getConfigService().getAgentConfig(appName).getBrowserMonitoringConfig();
        this.isSslForHttp = config.isSslForHttpSet() ? Boolean.valueOf(config.isSslForHttp()) : null;
    }

    public String getFooter(BeaconTransactionState state) {
        String jsonString = this.jsonToString(this.createMapWithData(state));
        if (jsonString != null) {
            return FOOTER_START_SCRIPT + jsonString + FOOTER_END;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String jsonToString(Map<String, ? extends Object> map) {
        IOException e222;
        String string;
        OutputStreamWriter out;
        ByteArrayOutputStream baos;
        block16: {
            baos = null;
            out = null;
            baos = new ByteArrayOutputStream();
            out = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            JSONObject.writeJSONString(map, out);
            ((Writer)out).flush();
            string = new String(baos.toByteArray());
            Object var7_6 = null;
            if (out == null) break block16;
            try {
                ((Writer)out).close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        return string;
        catch (Exception e3) {
            IOException e222;
            String string2;
            block18: {
                try {
                    Agent.LOG.log(Level.INFO, "An error occured when creating the rum footer. Issue:" + e3.getMessage());
                    if (Agent.LOG.isFinestEnabled()) {
                        Agent.LOG.log(Level.FINEST, "Exception when creating rum footer. ", e3);
                    }
                    string2 = null;
                    Object var7_7 = null;
                    if (out == null) break block18;
                }
                catch (Throwable throwable) {
                    block20: {
                        IOException e222;
                        Object var7_8 = null;
                        if (out != null) {
                            try {
                                ((Writer)out).close();
                            }
                            catch (IOException e222) {
                                // empty catch block
                            }
                        }
                        if (baos == null) break block20;
                        try {
                            baos.close();
                        }
                        catch (IOException e222) {}
                    }
                    throw throwable;
                }
                try {
                    ((Writer)out).close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            return string2;
        }
    }

    private Map<String, Object> createMapWithData(BeaconTransactionState state) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put(BEACON_KEY, this.beacon);
        output.put(ERROR_BEACON_KEY, this.errorBeacon);
        output.put(LICENSE_KEY, this.browserKey);
        output.put(APPLCATION_ID_KEY, this.appId);
        output.put(AGENT_PAYLOAD_SCRIPT_KEY, this.payloadScript);
        output.put(QUEUE_TIME_KEY, state.getExternalTimeInMilliseconds());
        output.put(APP_TIME_KEY, state.getDurationInMilliseconds());
        output.put(TRANSACTION_NAME_KEY, this.obfuscate(state.getTransactionName()));
        this.addToMapIfNotNullOrEmpty(output, AGENT_TOKEN_KEY, state.getTraceToken());
        this.addToMapIfNotNullOrEmpty(output, TRAN_TRACE_GUID_KEY, state.getOrCreateGuid());
        this.addToMapIfNotNullOrEmpty(output, SSL_FOR_HTTP_KEY, this.isSslForHttp);
        this.addToMapIfNotNullAndObfuscate(output, ATTS_KEY, BeaconFooter.getAttributes(state));
        return output;
    }

    protected static Map<String, Object> getAttributes(BeaconTransactionState state) {
        Map<String, Object> atts;
        if (ServiceFactory.getAttributesService().isAttributesEnabledForBrowser(state.getAppName())) {
            Map<String, ? extends Object> userAtts = ServiceFactory.getAttributesService().filterBrowserAttributes(state.getAppName(), state.getUserAttributes());
            Map<String, ? extends Object> agentAtts = ServiceFactory.getAttributesService().filterBrowserAttributes(state.getAppName(), state.getAgentAttributes());
            atts = new HashMap<String, Object>(3);
            if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity() && !userAtts.isEmpty()) {
                atts.put("u", userAtts);
            }
            if (!agentAtts.isEmpty()) {
                atts.put("a", agentAtts);
            }
        } else {
            atts = Collections.emptyMap();
        }
        return atts;
    }

    private void addToMapIfNotNullOrEmpty(Map<String, Object> map, String key, String value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    private void addToMapIfNotNullOrEmpty(Map<String, Object> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void addToMapIfNotNullAndObfuscate(Map<String, Object> map, String key, Map<String, ? extends Object> value) {
        String output;
        if (value != null && !value.isEmpty() && (output = this.jsonToString(value)) != null && !output.isEmpty()) {
            map.put(key, this.obfuscate(output));
        }
    }

    private String obfuscate(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        String licenseKey = ServiceFactory.getConfigService().getDefaultAgentConfig().getLicenseKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(name, licenseKey.substring(0, 13));
        }
        catch (UnsupportedEncodingException e) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Error obfuscating {0}: {1}", name, e);
                Agent.LOG.finer(msg);
            }
            return "";
        }
    }
}

