/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.BrowserMonitoringConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserMonitoringConfigImpl
extends BaseConfig
implements BrowserMonitoringConfig {
    public static final String AUTO_INSTRUMENT = "auto_instrument";
    public static final String DISABLE_AUTO_PAGES = "disabled_auto_pages";
    public static final String SSL_FOR_HTTP = "ssl_for_http";
    public static final String LOADER_TYPE = "loader";
    public static final String DEBUG = "debug";
    public static final String ALLOW_MULTIPLE_FOOTERS = "allow_multiple_footers";
    public static final boolean DEFAULT_AUTO_INSTRUMENT = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.browser_monitoring.";
    public static final String DEFAULT_LOADER_TYPE = "rum";
    public static final boolean DEFAULT_DEBUG = false;
    public static final boolean DEFAULT_SSL_FOR_HTTP = true;
    public static final boolean DEFAULT_ALLOW_MULTIPLE_FOOTERS = false;
    private final boolean auto_instrument = this.getProperty("auto_instrument", true);
    private final Set<String> disabledAutoPages = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings("disabled_auto_pages")));
    private final String loaderType = this.getProperty("loader", "rum");
    private final boolean debug = this.getProperty("debug", false);
    private final boolean sslForHttp;
    private final boolean isSslForHttpSet;
    private final boolean multipleFooters;

    private BrowserMonitoringConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        Boolean sslForHttpTmp = (Boolean)this.getProperty(SSL_FOR_HTTP);
        this.isSslForHttpSet = sslForHttpTmp != null;
        this.sslForHttp = this.isSslForHttpSet ? sslForHttpTmp : true;
        this.multipleFooters = this.getProperty(ALLOW_MULTIPLE_FOOTERS, false);
    }

    @Override
    public boolean isAutoInstrumentEnabled() {
        return this.auto_instrument;
    }

    static BrowserMonitoringConfig createBrowserMonitoringConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new BrowserMonitoringConfigImpl(settings);
    }

    @Override
    public Set<String> getDisabledAutoPages() {
        return this.disabledAutoPages;
    }

    @Override
    public String getLoaderType() {
        return this.loaderType;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isSslForHttp() {
        return this.sslForHttp;
    }

    @Override
    public boolean isSslForHttpSet() {
        return this.isSslForHttpSet;
    }

    @Override
    public boolean isAllowMultipleFooters() {
        return this.multipleFooters;
    }
}

