/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigHelper;
import com.newrelic.agent.config.AgentConfigImpl;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.ConfigServiceImpl;
import com.newrelic.agent.config.ConfigurationException;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigServiceFactory {
    public static ConfigService createConfigService(AgentConfig config, Map<String, Object> localSettings) {
        return new ConfigServiceImpl(config, null, localSettings);
    }

    public static ConfigService createConfigServiceUsingSettings(Map<String, Object> settings) {
        return new ConfigServiceImpl(AgentConfigImpl.createAgentConfig(settings), null, settings);
    }

    public static ConfigService createConfigService() throws ConfigurationException {
        File configFile = ConfigServiceFactory.getConfigFile();
        Map<String, Object> configSettings = ConfigServiceFactory.getConfigurationFileSettings(configFile);
        AgentConfig config = AgentConfigImpl.createAgentConfig(configSettings);
        ConfigServiceFactory.validateConfig(config);
        return new ConfigServiceImpl(config, configFile, configSettings);
    }

    public static Map<String, Object> getConfigurationFileSettings(File configFile) throws ConfigurationException {
        String msg = MessageFormat.format("Loading configuration file \"{0}\"", configFile.getPath());
        Agent.LOG.info(msg);
        try {
            return AgentConfigHelper.getConfigurationFileSettings(configFile);
        }
        catch (Exception e) {
            msg = MessageFormat.format("An error occurred reading the configuration file {0}. Check the permissions and format of the file. - {1}", configFile.getAbsolutePath(), e.toString());
            throw new ConfigurationException(msg, e);
        }
    }

    private static File getConfigFile() throws ConfigurationException {
        File configFile = ConfigFileHelper.findConfigFile();
        if (configFile == null) {
            throw new ConfigurationException("Failed to find the configuration file");
        }
        return configFile;
    }

    private static void validateConfig(AgentConfig config) throws ConfigurationException {
        if (config.getApplicationName() == null) {
            throw new ConfigurationException("The agent requires an application name.  Check the app_name setting in newrelic.yml");
        }
    }
}

