/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.logging.IAgentLogger;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hostname {
    private Hostname() {
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static String getDisplayHostname(IAgentLogger log, AgentConfig config, String defaultHostname, String appName) {
        String specifiedHost = (String)config.getValue("process_host.display_name", defaultHostname);
        log.log(Level.INFO, "Display host name is {0} for application {1}", new Object[]{specifiedHost, appName});
        return specifiedHost;
    }

    public static String getHostname(IAgentLogger log, AgentConfig config) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Agent.LOG.log(Level.FINE, "Error getting host name", e);
            try {
                InetAddress inetAddress = Hostname.getInetAddress(config);
                if (inetAddress == null) {
                    Agent.LOG.severe("Unable to obtain a host name for this JVM, defaulting to localhost." + Hostname.getMessage());
                    return "localhost";
                }
                Agent.LOG.severe("Unable to obtain a host name for this JVM.  Using IP address." + Hostname.getMessage());
                return inetAddress.getHostAddress();
            }
            catch (Exception err) {
                Agent.LOG.log(Level.FINE, "Error getting IP address", err);
                return "localhost";
            }
        }
    }

    private static String getMessage() {
        String osName = ManagementFactory.getOperatingSystemMXBean().getName();
        if ("Linux".equals(osName) || "Mac OS X".equals(osName)) {
            return "  You might need to add a host entry for this machine in /etc/hosts";
        }
        return "";
    }

    private static List<NetworkInterface> getNetworkInterfaces() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            return Collections.emptyList();
        }
    }

    protected static InetAddress getInetAddress(AgentConfig config) {
        List<NetworkInterface> networkInterfaces = Hostname.getNetworkInterfaces();
        if (!networkInterfaces.isEmpty()) {
            Boolean isIpv4 = Hostname.preferIpv4(config);
            for (NetworkInterface networkInterface : networkInterfaces) {
                InetAddress inetAddress;
                if (!networkInterface.getName().startsWith("eth") && !networkInterface.getName().startsWith("en") || (inetAddress = Hostname.getInetAddress(networkInterface, isIpv4)) == null) continue;
                return inetAddress;
            }
        }
        return null;
    }

    protected static Boolean preferIpv4(AgentConfig config) {
        Object value = config.getValue("process_host.ipv_preference", null);
        if (value != null) {
            if ("6".equals(String.valueOf(value))) {
                return Boolean.FALSE;
            }
            if ("4".equals(String.valueOf(value))) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private static InetAddress getInetAddress(NetworkInterface networkInterface, Boolean isIpv4) {
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        if (interfaceAddresses == null) {
            return null;
        }
        InetAddress candidate = null;
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            InetAddress inetAddress = interfaceAddress.getAddress();
            if (inetAddress == null) continue;
            if (isIpv4 == null) {
                candidate = inetAddress;
                break;
            }
            if (inetAddress instanceof Inet4Address) {
                candidate = inetAddress;
                if (isIpv4.booleanValue()) break;
            }
            if (!(inetAddress instanceof Inet6Address)) continue;
            candidate = inetAddress;
            if (isIpv4.booleanValue()) continue;
            break;
        }
        return candidate;
    }
}

