/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.tracers.metricname.MetricNameFormat;

public final class ParsedDatabaseStatement
implements MetricNameFormat {
    private final String operation;
    private final String model;
    private final boolean generateMetric;
    private final String metricName;
    private final String operationRollupMetricName;

    public ParsedDatabaseStatement(String model, String operation, boolean generateMetric) {
        this.model = model;
        this.operation = operation;
        this.generateMetric = generateMetric;
        this.metricName = new StringBuilder(50).append("Database/").append(model).append('/').append(operation).toString();
        this.operationRollupMetricName = "Database/" + operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getModel() {
        return this.model;
    }

    public boolean recordMetric() {
        return this.generateMetric;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String toString() {
        return this.operation + ' ' + this.model;
    }

    public String getTransactionSegmentName() {
        return this.getMetricName();
    }

    public String getOperationRollupMetricName() {
        return this.operationRollupMetricName;
    }

    public String getTransactionSegmentUri() {
        return null;
    }
}

