/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.ch.qos.logback.classic.spi;

import com.newrelic.agent.deps.ch.qos.logback.core.CoreConstants;

public class CallerData {
    public static final String NA = "?";
    private static final String LOG4J_CATEGORY = "org.apache.log4j.Category";
    public static final int LINE_NA = -1;
    public static final String CALLER_DATA_NA = "?#?:?" + CoreConstants.LINE_SEPARATOR;
    public static final StackTraceElement[] EMPTY_CALLER_DATA_ARRAY = new StackTraceElement[0];

    public static StackTraceElement[] extract(Throwable t, String fqnOfInvokingClass, int maxDepth) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] steArray = t.getStackTrace();
        int found = -1;
        for (int i = 0; i < steArray.length; ++i) {
            if (CallerData.isDirectlyInvokingClass(steArray[i].getClassName(), fqnOfInvokingClass)) {
                found = i + 1;
                continue;
            }
            if (found != -1) break;
        }
        if (found == -1) {
            return EMPTY_CALLER_DATA_ARRAY;
        }
        int availableDepth = steArray.length - found;
        int desiredDepth = maxDepth < availableDepth ? maxDepth : availableDepth;
        StackTraceElement[] callerDataArray = new StackTraceElement[desiredDepth];
        for (int i = 0; i < desiredDepth; ++i) {
            callerDataArray[i] = steArray[found + i];
        }
        return callerDataArray;
    }

    public static boolean isDirectlyInvokingClass(String currentClass, String fqnOfInvokingClass) {
        return currentClass.equals(fqnOfInvokingClass) || currentClass.equals(LOG4J_CATEGORY);
    }
}

