/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.install;

import java.io.File;

public class AppServerIdentifier {
    private static String tomcat5Marker = "/server/lib/catalina.jar";
    private static String tomcat67Marker = "/lib/catalina.jar";
    private static String jettyMarker = "/bin/jetty.sh";
    private static String jBoss4Marker = "/lib/jboss-common.jar";
    private static String jBoss56Marker = "/lib/jboss-common-core.jar";
    private static String jBoss7Marker = "/jboss-modules.jar";
    private static String glassfish3Marker = "/config/domain.xml";

    public static AppServerType getAppServerType(String path) throws Exception {
        return AppServerIdentifier.getAppServerType(new File(path));
    }

    public static AppServerType getAppServerType(File rootDir) throws Exception {
        if (!rootDir.exists()) {
            throw new Exception("App server root " + rootDir.toString() + "does not exist on filesystem.");
        }
        if (!rootDir.isDirectory()) {
            throw new Exception("App server root " + rootDir.toString() + "is not a directory.");
        }
        if (AppServerIdentifier.isTomcat(rootDir.toString())) {
            return AppServerType.TOMCAT;
        }
        if (AppServerIdentifier.isJetty(rootDir.toString())) {
            return AppServerType.JETTY;
        }
        if (AppServerIdentifier.isJBoss(rootDir.toString())) {
            return AppServerType.JBOSS;
        }
        if (AppServerIdentifier.isJBoss7(rootDir.toString())) {
            return AppServerType.JBOSS7;
        }
        if (AppServerIdentifier.isGlassfish(rootDir.toString())) {
            return AppServerType.GLASSFISH;
        }
        return AppServerType.UNKNOWN;
    }

    private static boolean isTomcat(String rootDir) {
        return AppServerIdentifier.markerFileExists(rootDir + tomcat5Marker) || AppServerIdentifier.markerFileExists(rootDir + tomcat67Marker);
    }

    private static boolean isJetty(String rootDir) {
        return AppServerIdentifier.markerFileExists(rootDir + jettyMarker);
    }

    private static boolean isJBoss(String rootDir) {
        return AppServerIdentifier.markerFileExists(rootDir + jBoss4Marker) || AppServerIdentifier.markerFileExists(rootDir + jBoss56Marker);
    }

    private static boolean isJBoss7(String rootDir) {
        return AppServerIdentifier.markerFileExists(rootDir + jBoss7Marker);
    }

    private static boolean isGlassfish(String rootDir) {
        return AppServerIdentifier.markerFileExists(rootDir + glassfish3Marker);
    }

    private static boolean markerFileExists(String path) {
        File markerFile = new File(path);
        return markerFile.exists() && markerFile.isFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppServerType {
        TOMCAT("Tomcat"),
        JETTY("Jetty"),
        JBOSS("JBoss"),
        JBOSS7("JBoss7"),
        GLASSFISH("Glassfish"),
        UNKNOWN("Unknown");

        private final String name;

        private AppServerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

