/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.dispatchers.Dispatcher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

class IgnoreApdexInvocationHandler
implements InvocationHandler {
    static final InvocationHandler INVOCATION_HANDLER = new IgnoreApdexInvocationHandler();

    private IgnoreApdexInvocationHandler() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Dispatcher dispatcher;
        Transaction transaction = Transaction.getTransaction();
        if (transaction != null && (dispatcher = transaction.getDispatcher()) != null) {
            dispatcher.setIgnoreApdex(true);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Set Ignore apdex to \"{0}\"", true);
                Agent.LOG.log(Level.FINER, msg, new Exception());
            }
        }
        return null;
    }
}

